/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.elements;

import io.netty.buffer.ByteBuf;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.apiimpl.TheOneProbeImp;
import mcjty.theoneprobe.apiimpl.client.ElementTextRender;
import mcjty.theoneprobe.network.NetworkTools;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ElementItemLabel
implements IElement {
    private final ItemStack itemStack;

    public ElementItemLabel(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public ElementItemLabel(ByteBuf buf) {
        this.itemStack = buf.readBoolean() ? NetworkTools.readItemStack(buf) : ItemStack.EMPTY;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(int x, int y) {
        if (!this.itemStack.isEmpty()) {
            String text = this.itemStack.getDisplayName();
            ElementTextRender.render(text, x, y);
        }
    }

    @Override
    public int getWidth() {
        if (!this.itemStack.isEmpty()) {
            String text = this.itemStack.getDisplayName();
            return ElementTextRender.getWidth(text);
        }
        return 10;
    }

    @Override
    public int getHeight() {
        return 10;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        if (!this.itemStack.isEmpty()) {
            buf.writeBoolean(true);
            NetworkTools.writeItemStack(buf, this.itemStack);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public int getID() {
        return TheOneProbeImp.ELEMENT_ITEMLABEL;
    }
}

