/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import java.util.Objects;
import mcjty.lib.api.power.IBigPower;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import mcjty.theoneprobe.compat.RedstoneFluxTools;
import mcjty.theoneprobe.config.Config;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class DebugProbeInfoProvider
implements IProbeInfoProvider {
    @Override
    public String getID() {
        return "theoneprobe:debug";
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        if (mode == ProbeMode.DEBUG && Config.showDebugInfo) {
            Block block = blockState.getBlock();
            BlockPos pos = data.getPos();
            this.showDebugInfo(probeInfo, world, blockState, pos, block, data.getSideHit());
        }
    }

    private void showDebugInfo(IProbeInfo probeInfo, World world, IBlockState blockState, BlockPos pos, Block block, EnumFacing side) {
        TileEntity te;
        String simpleName = block.getClass().getSimpleName();
        IProbeInfo vertical = probeInfo.vertical(new LayoutStyle().borderColor(-48060).spacing(2)).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_block.reg_name_indicator*} " + (Object)((Object)TextStyleClass.INFO) + Objects.requireNonNull(block.getRegistryName())).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_block.unlocalized_name_indicator*} " + (Object)((Object)TextStyleClass.INFO) + block.getTranslationKey()).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_block.meta_indicator*} " + (Object)((Object)TextStyleClass.INFO) + blockState.getBlock().getMetaFromState(blockState)).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_block.class_indicator*} " + (Object)((Object)TextStyleClass.INFO) + simpleName).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_block.hardness_indicator*} " + (Object)((Object)TextStyleClass.INFO) + block.getBlockHardness(blockState, world, pos)).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_block.power_w_indicator*} " + (Object)((Object)TextStyleClass.INFO) + block.getWeakPower(blockState, (IBlockAccess)world, pos, side.getOpposite()) + (Object)((Object)TextStyleClass.LABEL) + ", {*theoneprobe.debug_block.power_s_indicator*} " + (Object)((Object)TextStyleClass.INFO) + block.getStrongPower(blockState, (IBlockAccess)world, pos, side.getOpposite()));
        int lightValue = block.getLightValue(blockState, (IBlockAccess)world, pos);
        if (lightValue > 0) {
            vertical.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_block.light_indicator*} " + (Object)((Object)TextStyleClass.INFO) + lightValue);
        }
        if ((te = world.getTileEntity(pos)) != null) {
            vertical.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_block.tile_entity_indicator*} " + (Object)((Object)TextStyleClass.INFO) + te.getClass().getSimpleName());
            if (te instanceof IBigPower) {
                vertical.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_block.energy_indicator*} " + (Object)((Object)TextStyleClass.INFO) + RedstoneFluxTools.getEnergy(te)).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_block.max_energy_indicator*} " + (Object)((Object)TextStyleClass.INFO) + RedstoneFluxTools.getMaxEnergy(te));
            }
        }
    }
}

