/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import java.text.DecimalFormat;
import java.util.Collection;
import java.util.UUID;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IEntityDisplayOverride;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.styles.ItemStyle;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import mcjty.theoneprobe.config.Config;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.UsernameCache;

public class DefaultProbeInfoEntityProvider
implements IProbeInfoEntityProvider {
    private static final DecimalFormat dfCommas = new DecimalFormat("##.#");

    @Override
    public String getID() {
        return "theoneprobe:entity.default";
    }

    @Override
    public void addProbeEntityInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
        IProbeConfig config = Config.getRealConfig();
        boolean handled = false;
        for (IEntityDisplayOverride override : TheOneProbe.theOneProbeImp.getEntityOverrides()) {
            if (!override.overrideStandardInfo(mode, probeInfo, player, world, entity, data)) continue;
            handled = true;
            break;
        }
        if (!handled) {
            DefaultProbeInfoEntityProvider.showStandardInfo(mode, probeInfo, entity, config);
        }
        if (entity instanceof EntityLivingBase) {
            Collection effects;
            int age;
            EntityLivingBase livingBase = (EntityLivingBase)entity;
            if (Tools.show(mode, config.getShowMobHealth())) {
                int health = (int)livingBase.getHealth();
                int maxHealth = (int)livingBase.getMaxHealth();
                int armor = livingBase.getTotalArmorValue();
                probeInfo.progress(health, maxHealth, probeInfo.defaultProgressStyle().lifeBar(true).showText(false).width(150).height(10));
                if (mode == ProbeMode.EXTENDED) {
                    probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.probe.health_indicator*} " + (Object)((Object)TextStyleClass.INFOIMP) + health + " / " + maxHealth);
                }
                if (armor > 0) {
                    probeInfo.progress(armor, armor, probeInfo.defaultProgressStyle().armorBar(true).showText(false).width(80).height(10));
                }
            }
            if (Tools.show(mode, config.getShowMobGrowth()) && entity instanceof EntityAgeable && (age = ((EntityAgeable)entity).getGrowingAge()) < 0) {
                probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.probe.growing_time_indicator*} " + age * -1 / 20 + "s");
            }
            if (Tools.show(mode, config.getShowMobPotionEffects()) && !(effects = livingBase.getActivePotionEffects()).isEmpty()) {
                IProbeInfo vertical = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(-1));
                float durationFactor = 1.0f;
                for (PotionEffect effect : effects) {
                    String s1 = "{*" + effect.getEffectName() + "*}";
                    Potion potion = effect.getPotion();
                    if (effect.getAmplifier() > 0) {
                        s1 = s1 + " " + "{*" + "potion.potency." + effect.getAmplifier() + "*}";
                    }
                    if (effect.getDuration() > 20) {
                        s1 = s1 + " (" + DefaultProbeInfoEntityProvider.getPotionDurationString(effect, durationFactor) + ")";
                    }
                    if (potion.isBadEffect()) {
                        vertical.text((Object)((Object)TextStyleClass.ERROR) + s1);
                        continue;
                    }
                    vertical.text((Object)((Object)TextStyleClass.OK) + s1);
                }
            }
        } else if (entity instanceof EntityItemFrame) {
            EntityItemFrame itemFrame = (EntityItemFrame)entity;
            ItemStack stack = itemFrame.getDisplayedItem();
            if (!stack.isEmpty()) {
                probeInfo.horizontal(new LayoutStyle().spacing(10).alignment(ElementAlignment.ALIGN_CENTER)).item(stack, new ItemStyle().width(16).height(16)).text((Object)((Object)TextStyleClass.INFO) + stack.getDisplayName());
                if (mode == ProbeMode.EXTENDED) {
                    probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.probe.rotation_indicator*} " + (Object)((Object)TextStyleClass.INFO) + itemFrame.getRotation());
                }
            } else {
                probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.probe.empty_indicator*}");
            }
        }
        if (Tools.show(mode, config.getAnimalOwnerSetting())) {
            UUID ownerId = null;
            if (entity instanceof IEntityOwnable) {
                ownerId = ((IEntityOwnable)entity).getOwnerId();
            } else if (entity instanceof EntityHorse) {
                ownerId = ((EntityHorse)entity).getOwnerUniqueId();
            }
            if (ownerId != null) {
                String username = UsernameCache.getLastKnownUsername((UUID)ownerId);
                if (username == null) {
                    probeInfo.text((Object)((Object)TextStyleClass.WARNING) + "{*theoneprobe.probe.unknown_owner_indicator*}");
                } else {
                    probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.probe.owned_by_indicator*} " + (Object)((Object)TextStyleClass.INFO) + username);
                }
            } else if (entity instanceof EntityTameable) {
                probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Tameable");
            }
        }
        if (entity instanceof EntityWolf && Config.showCollarColor && ((EntityWolf)entity).isTamed()) {
            EnumDyeColor collarColor = ((EntityWolf)entity).getCollarColor();
            probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.probe.collar_color_indicator*} " + (Object)((Object)TextStyleClass.INFO) + collarColor.getName());
        }
    }

    public static String getPotionDurationString(PotionEffect effect, float factor) {
        if (effect.getDuration() == Short.MAX_VALUE) {
            return "**:**";
        }
        int i = MathHelper.floor((float)((float)effect.getDuration() * factor));
        return DefaultProbeInfoEntityProvider.ticksToElapsedTime(i);
    }

    public static String ticksToElapsedTime(int ticks) {
        int i = ticks / 20;
        int j = i / 60;
        return (i %= 60) < 10 ? j + ":0" + i : j + ":" + i;
    }

    public static void showStandardInfo(ProbeMode mode, IProbeInfo probeInfo, Entity entity, IProbeConfig config) {
        String modid = Tools.getModName(entity);
        if (Tools.show(mode, config.getShowModName())) {
            probeInfo.horizontal().entity(entity).vertical().text((Object)((Object)TextStyleClass.NAME) + entity.getDisplayName().getFormattedText()).text((Object)((Object)TextStyleClass.MODNAME) + modid);
        } else {
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).entity(entity).text((Object)((Object)TextStyleClass.NAME) + entity.getDisplayName().getFormattedText());
        }
    }
}

