/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import javax.annotation.Nonnull;
import mcjty.theoneprobe.Utilities;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.BlockJukebox;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class JukeboxProvider
implements IProbeInfoProvider {
    @Override
    public String getID() {
        return Utilities.getProviderId("jukebox");
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, @Nonnull IBlockState blockState, IProbeHitData data) {
        TileEntity tileEntity;
        if (blockState.getBlock() instanceof BlockJukebox && (tileEntity = world.getTileEntity(data.getPos())) instanceof BlockJukebox.TileEntityJukebox) {
            BlockJukebox.TileEntityJukebox jukebox = (BlockJukebox.TileEntityJukebox)tileEntity;
            ItemStack record = jukebox.getRecord();
            if (record.isEmpty()) {
                probeInfo.text((Object)((Object)TextStyleClass.WARNING) + "{*theoneprobe.probe.empty_indicator*}");
                return;
            }
            IProbeInfo horizontalPane = probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
            horizontalPane.item(record);
            String recordName = record.getItem() instanceof ItemRecord ? ((ItemRecord)record.getItem()).getRecordNameLocal() : record.getDisplayName();
            horizontalPane.text((Object)((Object)TextStyleClass.INFO) + "{*theoneprobe.probe.playing_indicator*} " + I18n.format((String)recordName, (Object[])new Object[0]));
        }
    }
}

