/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mcjty.theoneprobe.Utilities;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecartContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class MinecartInfoProvider
implements IProbeInfoEntityProvider {
    private final List<ItemStack> stacks = new ArrayList<ItemStack>();
    private final Set<Item> foundItems = new HashSet<Item>();

    @Override
    public String getID() {
        return Utilities.getProviderId("minecart");
    }

    @Override
    public void addProbeEntityInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
        if (entity instanceof EntityMinecartContainer) {
            if (entity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                IItemHandler capability = (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                if (capability == null) {
                    this.stacks.clear();
                    this.foundItems.clear();
                    return;
                }
                int maxSlots = capability.getSlots();
                for (int i = 0; i < maxSlots; ++i) {
                    Utilities.addItemStack(this.stacks, this.foundItems, capability.getStackInSlot(i));
                }
            } else {
                IInventory inventory = (IInventory)entity;
                int maxSlots = inventory.getSizeInventory();
                for (int i = 0; i < maxSlots; ++i) {
                    Utilities.addItemStack(this.stacks, this.foundItems, inventory.getStackInSlot(i));
                }
            }
            if (!this.stacks.isEmpty()) {
                Utilities.showChestContents(probeInfo, this.stacks, mode);
            }
            this.stacks.clear();
            this.foundItems.clear();
        }
    }
}

