/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mcjty.theoneprobe.ClientTools;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.IOverlayStyle;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.ProbeInfo;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.gui.HitBox;
import mcjty.theoneprobe.gui.Preset;
import mcjty.theoneprobe.gui.PresetBuilder;
import mcjty.theoneprobe.rendering.RenderHelper;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiConfig
extends GuiScreen {
    private static final int WIDTH = 230;
    private static final int HEIGHT = 230;
    private int guiLeft;
    private int guiTop;
    private static final ResourceLocation background = new ResourceLocation("theoneprobe", "textures/gui/config.png");
    private static final ResourceLocation scene = new ResourceLocation("theoneprobe", "textures/gui/scene.png");
    private List<HitBox> hitboxes = Collections.emptyList();
    int[][] hitboxPositionMap = new int[][]{{2, 2, -1, -1}, {-1, 2, -1, -1}, {-1, 2, 2, -1}, {2, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, 5, -1}, {2, -1, -1, 5}, {-1, -1, -1, 15}, {-1, -1, 5, 2}};

    public boolean doesGuiPauseGame() {
        return false;
    }

    public void initGui() {
        super.initGui();
        this.guiLeft = (this.width - 230 - 230) / 2;
        this.guiTop = (this.height - 230) / 2;
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        super.drawScreen(mouseX, mouseY, partialTicks);
        this.mc.getTextureManager().bindTexture(background);
        this.drawTexturedModalRect(this.guiLeft + 230, this.guiTop, 0, 0, 230, 230);
        this.mc.getTextureManager().bindTexture(scene);
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, 230, 230);
        this.renderProbe(Config.getProbeNoteBlock());
        int x = 230 + this.guiLeft + 10;
        int y = this.guiTop + 10;
        RenderHelper.renderText(ClientTools.mc, x, y, TextFormatting.GOLD + I18n.format((String)"gui.theoneprobe.gui_note_config.title.placement", (Object[])new Object[0]));
        RenderHelper.renderText(ClientTools.mc, x + 10, y += 12, I18n.format((String)"gui.theoneprobe.gui_note_config.body.1", (Object[])new Object[0]));
        RenderHelper.renderText(ClientTools.mc, x + 10, y += 10, I18n.format((String)"gui.theoneprobe.gui_note_config.body.2", (Object[])new Object[0]));
        this.hitboxes = new ArrayList<HitBox>();
        RenderHelper.renderText(ClientTools.mc, x, y += 20, TextFormatting.GOLD + I18n.format((String)"gui.theoneprobe.gui_note_config.title.presets", (Object[])new Object[0]));
        y += 12;
        for (Preset preset : PresetBuilder.getPresets()) {
            y = this.addPreset(x, y, preset);
        }
        RenderHelper.renderText(ClientTools.mc, x, y += 5, TextFormatting.GOLD + I18n.format((String)"gui.theoneprobe.gui_note_config.title.scale", (Object[])new Object[0]));
        RenderHelper.renderText(ClientTools.mc, x + 10, y += 12, I18n.format((String)"gui.theoneprobe.gui_note_config.body.3", (Object[])new Object[0]));
        this.addButton(x + 10, y += 12, "--", () -> Config.setScale(Config.getScale() + 0.2f));
        this.addButton((x += 36) + 10, y, "-", () -> Config.setScale(Config.getScale() + 0.1f));
        this.addButton((x += 36) + 10, y, "0", () -> Config.setScale(1.0f));
        this.addButton((x += 36) + 10, y, "+", () -> Config.setScale(Config.getScale() - 0.1f));
        this.addButton((x += 36) + 10, y, "++", () -> Config.setScale(Config.getScale() - 0.2f));
        int margin = 90;
        int[] xPositions = new int[]{0, margin, 230 - margin};
        int[] yPositions = new int[]{0, margin, 230 - margin};
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int x1 = xPositions[i];
                int y1 = yPositions[j];
                int x2 = i == 2 ? 230 : xPositions[i + 1];
                int y2 = j == 2 ? 230 : yPositions[j + 1];
                int[] pos = this.hitboxPositionMap[j * 3 + i];
                this.hitboxes.add(new HitBox(x1, y1, x2, y2, () -> Config.setPos(pos[0], pos[1], pos[2], pos[3])));
            }
        }
    }

    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            for (HitBox box : this.hitboxes) {
                if (!box.isHit(mouseX - this.guiLeft, mouseY - this.guiTop)) continue;
                box.call();
            }
        }
    }

    private int addPreset(int x, int y, Preset preset) {
        GuiConfig.drawRect((int)(x + 10), (int)(y - 1), (int)(x + 10 + 230 - 50), (int)(y + 10), (int)Config.getProbeButtonColor());
        RenderHelper.renderText(ClientTools.mc, x + 20, y, preset.getName());
        this.hitboxes.add(new HitBox(x + 10 - this.guiLeft, y - 1 - this.guiTop, x + 10 + 230 - 50 - this.guiLeft, y + 10 - this.guiTop, () -> PresetBuilder.applyPreset(preset)));
        return y += 14;
    }

    private void addButton(int x, int y, String text, Runnable runnable) {
        GuiConfig.drawRect((int)x, (int)y, (int)(x + 30 - 1), (int)(y + 14 - 1), (int)Config.getProbeButtonColor());
        RenderHelper.renderText(ClientTools.mc, x + 3, y + 3, text);
        this.hitboxes.add(new HitBox(x - this.guiLeft, y - this.guiTop, x + 30 - 1 - this.guiLeft, y + 14 - 1 - this.guiTop, runnable));
    }

    private void renderProbe(String blockName) {
        Block block = Block.getBlockFromName((String)blockName);
        if (block == Blocks.AIR || block == null) {
            TheOneProbe.setup.getLogger().error("Block not found: {}! Defaulting to Log", (Object)blockName);
            block = Blocks.LOG;
        }
        String modid = Tools.getModName(block);
        ProbeInfo probeInfo = TheOneProbe.theOneProbeImp.create();
        ItemStack pickBlock = new ItemStack(block);
        probeInfo.horizontal().item(pickBlock).vertical().text((Object)((Object)TextStyleClass.NAME) + pickBlock.getDisplayName()).text((Object)((Object)TextStyleClass.MODNAME) + modid);
        probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.probe.fuel_indicator*} " + (Object)((Object)TextStyleClass.INFO) + "5 volts");
        probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.probe.error_indicator*} " + (Object)((Object)TextStyleClass.ERROR) + "Oups!");
        this.renderElements(probeInfo, Config.getDefaultOverlayStyle());
    }

    private void renderElements(ProbeInfo probeInfo, IOverlayStyle style) {
        int margin;
        GlStateManager.pushMatrix();
        GlStateManager.scale((float)(1.0f / Config.tooltipScale), (float)(1.0f / Config.tooltipScale), (float)(1.0f / Config.tooltipScale));
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.disableLighting();
        int w = probeInfo.getWidth();
        int h = probeInfo.getHeight();
        int offset = style.getBorderOffset();
        int thick = style.getBorderThickness();
        int n = margin = thick > 0 ? offset + thick + 3 : 0;
        if (thick > 0) {
            w += margin * 2;
            h += margin * 2;
        }
        int x = this.calculateXPosition(style, w);
        int y = this.calculateYPosition(style, h);
        x += this.guiLeft;
        y += this.guiTop;
        double factor = (double)(Config.tooltipScale - 1.0f) * 1.4 + 1.0;
        x *= (int)factor;
        y *= (int)factor;
        if (thick > 0) {
            int x2 = x + w - 1;
            int y2 = y + h - 1;
            if (offset > 0) {
                RenderHelper.drawThickBeveledBox(x, y, x2, y2, thick, style.getBoxColor(), style.getBoxColor(), style.getBoxColor());
            }
            RenderHelper.drawThickBeveledBox(x + offset, y + offset, x2 - offset, y2 - offset, thick, style.getBorderColor(), style.getBorderColor(), style.getBoxColor());
        }
        if (!ClientTools.mc.isGamePaused()) {
            RenderHelper.rot += 0.5f;
        }
        probeInfo.render(x + margin, y + margin);
        GlStateManager.popMatrix();
    }

    private int calculateXPosition(IOverlayStyle style, int width) {
        if (style.getLeftX() != -1) {
            return style.getLeftX();
        }
        if (style.getRightX() != -1) {
            return 230 - width - style.getRightX();
        }
        return (230 - width) / 2;
    }

    private int calculateYPosition(IOverlayStyle style, int height) {
        if (style.getTopY() != -1) {
            return style.getTopY();
        }
        if (style.getBottomY() != -1) {
            return 230 - height - style.getBottomY();
        }
        return (230 - height) / 2;
    }
}

