/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeConfigProvider;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.ProbeHitEntityData;
import mcjty.theoneprobe.apiimpl.ProbeInfo;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.items.ModItems;
import mcjty.theoneprobe.network.PacketHandler;
import mcjty.theoneprobe.network.PacketReturnEntityInfo;
import mcjty.theoneprobe.network.ThrowableIdentity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketGetEntityInfo
implements IMessage {
    private int dim;
    private UUID uuid;
    private ProbeMode mode;
    private Vec3d hitVec;

    public void fromBytes(ByteBuf buf) {
        this.dim = buf.readInt();
        this.uuid = new UUID(buf.readLong(), buf.readLong());
        this.mode = ProbeMode.values()[buf.readByte()];
        if (buf.readBoolean()) {
            this.hitVec = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dim);
        buf.writeLong(this.uuid.getMostSignificantBits());
        buf.writeLong(this.uuid.getLeastSignificantBits());
        buf.writeByte(this.mode.ordinal());
        buf.writeBoolean(this.hitVec != null);
        if (this.hitVec != null) {
            buf.writeDouble(this.hitVec.x);
            buf.writeDouble(this.hitVec.y);
            buf.writeDouble(this.hitVec.z);
        }
    }

    public PacketGetEntityInfo() {
    }

    public PacketGetEntityInfo(int dim, ProbeMode mode, RayTraceResult mouseOver, Entity entity) {
        this.dim = dim;
        this.uuid = entity.getPersistentID();
        this.mode = mode;
        this.hitVec = mouseOver.hitVec;
    }

    private static ProbeInfo getProbeInfo(EntityPlayer player, ProbeMode mode, World world, Entity entity, Vec3d hitVec) {
        if (Config.needsProbe == 3) {
            if (!ModItems.hasAProbeSomewhere(player) && mode == ProbeMode.EXTENDED) {
                mode = ProbeMode.NORMAL;
            }
        } else if (Config.needsProbe == 2 && !ModItems.hasAProbeSomewhere(player)) {
            return null;
        }
        ProbeInfo probeInfo = TheOneProbe.theOneProbeImp.create();
        ProbeHitEntityData data = new ProbeHitEntityData(hitVec);
        IProbeConfig probeConfig = TheOneProbe.theOneProbeImp.createProbeConfig();
        for (IProbeConfigProvider configProvider : TheOneProbe.theOneProbeImp.getConfigProviders()) {
            configProvider.getProbeConfig(probeConfig, player, world, entity, data);
        }
        Config.setRealConfig(probeConfig);
        for (IProbeInfoEntityProvider provider : TheOneProbe.theOneProbeImp.getEntityProviders()) {
            try {
                provider.addProbeEntityInfo(mode, probeInfo, player, world, entity, data);
            }
            catch (Throwable e) {
                ThrowableIdentity.registerThrowable(e);
                probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Error: " + (Object)((Object)TextStyleClass.ERROR) + provider.getID());
            }
        }
        return probeInfo;
    }

    public static class Handler
    implements IMessageHandler<PacketGetEntityInfo, IMessage> {
        public IMessage onMessage(PacketGetEntityInfo message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).addScheduledTask(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketGetEntityInfo message, MessageContext ctx) {
            Entity entity;
            WorldServer world = DimensionManager.getWorld((int)message.dim);
            if (world != null && (entity = world.getEntityFromUuid(message.uuid)) != null) {
                ProbeInfo probeInfo = PacketGetEntityInfo.getProbeInfo((EntityPlayer)ctx.getServerHandler().player, message.mode, (World)world, entity, message.hitVec);
                PacketHandler.INSTANCE.sendTo((IMessage)new PacketReturnEntityInfo(message.uuid, probeInfo), ctx.getServerHandler().player);
            }
        }
    }
}

