/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.network;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.config.Config;

public class ThrowableIdentity {
    private final String identifier;
    private static final Map<ThrowableIdentity, Long> caughtThrowables = new HashMap<ThrowableIdentity, Long>();

    public static void registerThrowable(Throwable e) {
        long lasttime;
        ThrowableIdentity identity = new ThrowableIdentity(e);
        long currentTimeMillis = System.currentTimeMillis();
        if (caughtThrowables.containsKey(identity) && currentTimeMillis < (lasttime = caughtThrowables.get(identity).longValue()) + (long)Config.loggingThrowableTimeout) {
            return;
        }
        caughtThrowables.put(identity, currentTimeMillis);
        TheOneProbe.setup.getLogger().debug("The One Probe caught error: ", e);
    }

    public ThrowableIdentity(Throwable e) {
        String message = e.getMessage();
        StringBuilder builder = new StringBuilder(message == null ? "<null>" : message);
        StackTraceElement[] st = e.getStackTrace();
        for (int i = 0; i < Math.min(3, st.length); ++i) {
            builder.append(st[i].getClassName()).append(st[i].getFileName()).append(st[i].getMethodName()).append(st[i].getLineNumber());
        }
        this.identifier = builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThrowableIdentity that = (ThrowableIdentity)o;
        return Objects.equals(this.identifier, that.identifier);
    }

    public int hashCode() {
        return this.identifier != null ? this.identifier.hashCode() : 0;
    }
}

