/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.probe;

import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.items.ModItems;
import mcjty.theoneprobe.setup.GuiProxy;
import mcjty.theoneprobe.setup.Registration;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ProbeBase
extends Item {
    public ProbeBase(String registryName, String unlocalizedName) {
        this.setTranslationKey("theoneprobe." + unlocalizedName);
        this.setRegistryName(registryName);
        this.setMaxStackSize(1);
        this.setCreativeTab(ModItems.tabProbe);
        Registration.addItem(this);
    }

    public ProbeBase(String registryName) {
        this.setTranslationKey("theoneprobe." + registryName);
        this.setRegistryName(registryName);
        this.setMaxStackSize(1);
        this.setCreativeTab(ModItems.tabProbe);
        Registration.addItem(this);
    }

    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.getHeldItem(hand);
        if (world.isRemote) {
            this.handleRightClickClient(world, player, hand, stack);
        } else {
            this.handleRightClickServer(world, player, hand, stack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    protected void handleRightClickClient(World world, EntityPlayer player, EnumHand hand, ItemStack stack) {
        player.openGui((Object)TheOneProbe.instance, GuiProxy.GUI_CONFIG, player.getEntityWorld(), (int)player.posX, (int)player.posY, (int)player.posZ);
    }

    protected void handleRightClickServer(World world, EntityPlayer player, EnumHand hand, ItemStack stack) {
    }
}

