/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.elements;

import io.netty.buffer.ByteBuf;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.apiimpl.TheOneProbeImp;
import mcjty.theoneprobe.apiimpl.client.ElementTextRender;
import mcjty.theoneprobe.network.NetworkTools;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ElementFluidLabel
implements IElement {
    private final String fluidName;
    private final int amount;
    private String translatedName;

    public ElementFluidLabel(FluidStack fluid) {
        if (fluid == null) {
            this.fluidName = "";
            this.amount = 0;
        } else {
            this.fluidName = fluid.getFluid().getName();
            this.amount = fluid.amount;
        }
    }

    public ElementFluidLabel(ByteBuf buf) {
        this.fluidName = NetworkTools.readStringCompact(buf);
        this.amount = buf.readInt();
        this.translatedName = this.getTranslatedName();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        NetworkTools.writeStringCompact(buf, this.fluidName);
        buf.writeInt(this.amount);
    }

    @Override
    public void render(int x, int y) {
        if (this.translatedName != null && !this.translatedName.isEmpty()) {
            ElementTextRender.render(this.translatedName, x, y);
        }
    }

    @Override
    public int getWidth() {
        if (this.translatedName != null && !this.translatedName.isEmpty()) {
            return ElementTextRender.getWidth(this.translatedName);
        }
        return 10;
    }

    @Override
    public int getHeight() {
        return 10;
    }

    @Override
    public int getID() {
        return TheOneProbeImp.ELEMENT_FLUIDLABEL;
    }

    @SideOnly(value=Side.CLIENT)
    private String getTranslatedName() {
        if (this.fluidName == null || this.fluidName.isEmpty()) {
            return "";
        }
        Fluid fluid = FluidRegistry.getFluid((String)this.fluidName);
        if (fluid == null) {
            TheOneProbe.setup.getLogger().error("Could not find fluid with name {}", (Object)this.fluidName);
            return this.fluidName;
        }
        return fluid.getLocalizedName(new FluidStack(fluid, this.amount));
    }
}

