/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.elements;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IIconStyle;
import mcjty.theoneprobe.apiimpl.TheOneProbeImp;
import mcjty.theoneprobe.apiimpl.client.ElementIconRender;
import mcjty.theoneprobe.apiimpl.styles.IconStyle;
import mcjty.theoneprobe.network.NetworkTools;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ElementIcon
implements IElement {
    private final ResourceLocation icon;
    private final short u;
    private final short v;
    private final short w;
    private final short h;
    private final IIconStyle style;

    public ElementIcon(ResourceLocation icon, int u, int v, int w, int h, IIconStyle style) {
        this.icon = icon;
        this.u = (short)u;
        this.v = (short)v;
        this.w = (short)w;
        this.h = (short)h;
        this.style = style;
    }

    public ElementIcon(ByteBuf buf) {
        this.icon = new ResourceLocation(Objects.requireNonNull(NetworkTools.readStringCompact(buf)), Objects.requireNonNull(NetworkTools.readStringCompact(buf)));
        this.u = buf.readShort();
        this.v = buf.readShort();
        this.w = buf.readShort();
        this.h = buf.readShort();
        this.style = new IconStyle().width(buf.readShort()).height(buf.readShort()).textureWidth(buf.readShort()).textureHeight(buf.readShort());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(int x, int y) {
        ElementIconRender.render(this.icon, x, y, this.w, this.h, this.u, this.v, this.style.getTextureWidth(), this.style.getTextureHeight());
    }

    @Override
    public int getWidth() {
        return this.style.getWidth();
    }

    @Override
    public int getHeight() {
        return this.style.getHeight();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        NetworkTools.writeStringCompact(buf, this.icon.getNamespace());
        NetworkTools.writeStringCompact(buf, this.icon.getPath());
        buf.writeShort((int)this.u);
        buf.writeShort((int)this.v);
        buf.writeShort((int)this.w);
        buf.writeShort((int)this.h);
        buf.writeShort((int)((short)this.style.getWidth()));
        buf.writeShort((int)((short)this.style.getHeight()));
        buf.writeShort((int)((short)this.style.getTextureWidth()));
        buf.writeShort((int)((short)this.style.getTextureHeight()));
    }

    @Override
    public int getID() {
        return TheOneProbeImp.ELEMENT_ICON;
    }
}

