/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mcjty.theoneprobe.Utilities;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.AbstractChestHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ChestHorseInfoProvider
implements IProbeInfoEntityProvider {
    private final List<ItemStack> stacks = new ArrayList<ItemStack>();
    private final Set<Item> foundItems = new HashSet<Item>();

    @Override
    public String getID() {
        return Utilities.getProviderId("chest_horse");
    }

    @Override
    public void addProbeEntityInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
        if (entity instanceof AbstractChestHorse && ((AbstractChestHorse)entity).hasChest()) {
            if (entity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                IItemHandler capability = (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                if (capability == null) {
                    this.stacks.clear();
                    this.foundItems.clear();
                    return;
                }
                int maxSlots = capability.getSlots();
                for (int i = 3; i < maxSlots; ++i) {
                    Utilities.addItemStack(this.stacks, this.foundItems, capability.getStackInSlot(i));
                }
            } else {
                NBTTagCompound compound = entity.writeToNBT(new NBTTagCompound());
                if (!compound.hasKey("Items")) {
                    this.stacks.clear();
                    this.foundItems.clear();
                    return;
                }
                NBTTagList list = compound.getTagList("Items", 10);
                for (int i = 0; i < list.tagCount(); ++i) {
                    NBTTagCompound tagCompound = list.getCompoundTagAt(i);
                    int slot = tagCompound.getByte("Slot") & 0xFF;
                    if (slot <= 2) continue;
                    Utilities.addItemStack(this.stacks, this.foundItems, new ItemStack(tagCompound));
                }
            }
            if (!this.stacks.isEmpty()) {
                Utilities.showChestContents(probeInfo, this.stacks, mode);
            }
            this.stacks.clear();
            this.foundItems.clear();
        }
    }
}

