/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.Utilities;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.config.Config;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ChestInfoTools {
    static void showChestInfo(ProbeMode mode, IProbeInfo probeInfo, World world, BlockPos pos, IProbeConfig config) {
        ArrayList<ItemStack> stacks = null;
        IProbeConfig.ConfigMode chestMode = config.getShowChestContents();
        if (!(chestMode != IProbeConfig.ConfigMode.EXTENDED || Config.showSmallChestContentsWithoutSneaking <= 0 && Config.getInventoriesToShow().isEmpty())) {
            int slots;
            if (Config.getInventoriesToShow().contains(world.getBlockState(pos).getBlock().getRegistryName())) {
                chestMode = IProbeConfig.ConfigMode.NORMAL;
            } else if (Config.showSmallChestContentsWithoutSneaking > 0 && (slots = ChestInfoTools.getChestContents(world, pos, stacks = new ArrayList())) <= Config.showSmallChestContentsWithoutSneaking) {
                chestMode = IProbeConfig.ConfigMode.NORMAL;
            }
        } else if (chestMode == IProbeConfig.ConfigMode.NORMAL && !Config.getInventoriesToNotShow().isEmpty() && Config.getInventoriesToNotShow().contains(world.getBlockState(pos).getBlock().getRegistryName())) {
            chestMode = IProbeConfig.ConfigMode.EXTENDED;
        }
        if (Tools.show(mode, chestMode)) {
            if (stacks == null) {
                stacks = new ArrayList<ItemStack>();
                ChestInfoTools.getChestContents(world, pos, stacks);
            }
            if (!stacks.isEmpty()) {
                Utilities.showChestContents(probeInfo, stacks, mode);
            }
        }
    }

    private static int getChestContents(World world, BlockPos pos, List<ItemStack> stacks) {
        TileEntity te = world.getTileEntity(pos);
        HashSet<Item> foundItems = Config.compactEqualStacks ? new HashSet<Item>() : null;
        int maxSlots = 0;
        try {
            if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                IItemHandler capability = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                maxSlots = Objects.requireNonNull(capability).getSlots();
                for (int i = 0; i < maxSlots; ++i) {
                    Utilities.addItemStack(stacks, foundItems, capability.getStackInSlot(i));
                }
            } else if (te instanceof IInventory) {
                IInventory inventory = (IInventory)te;
                maxSlots = inventory.getSizeInventory();
                for (int i = 0; i < maxSlots; ++i) {
                    Utilities.addItemStack(stacks, foundItems, inventory.getStackInSlot(i));
                }
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException("{*theoneprobe.probe.get_contents*} " + world.getBlockState(pos).getBlock().getRegistryName() + " (" + te.getClass().getName() + ")", e);
        }
        return maxSlots;
    }
}

