/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import java.util.Collection;
import java.util.UUID;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import mcjty.theoneprobe.config.Config;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DebugProbeInfoEntityProvider
implements IProbeInfoEntityProvider {
    @Override
    public String getID() {
        return "theoneprobe:entity.debug";
    }

    @Override
    public void addProbeEntityInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
        if (mode == ProbeMode.DEBUG && Config.showDebugInfo) {
            IProbeInfo vertical = null;
            if (entity instanceof EntityLivingBase) {
                vertical = probeInfo.vertical(new LayoutStyle().borderColor(-48060).spacing(2));
                EntityLivingBase entityLivingBase = (EntityLivingBase)entity;
                float stepHeight = entityLivingBase.stepHeight;
                int totalArmorValue = entityLivingBase.getTotalArmorValue();
                int age = entityLivingBase.getIdleTime();
                float absorptionAmount = entityLivingBase.getAbsorptionAmount();
                float aiMoveSpeed = entityLivingBase.getAIMoveSpeed();
                int revengeTimer = entityLivingBase.getRevengeTimer();
                boolean isOnFire = entityLivingBase.isBurning();
                double posX = entityLivingBase.posX;
                double posY = entityLivingBase.posY;
                double posZ = entityLivingBase.posZ;
                double motionX = entityLivingBase.motionX;
                double motionY = entityLivingBase.motionY;
                double motionZ = entityLivingBase.motionZ;
                float health = entityLivingBase.getHealth();
                float maxHealth = entityLivingBase.getMaxHealth();
                Collection activeEffects = entityLivingBase.getActivePotionEffects();
                UUID uuid = entityLivingBase.getUniqueID();
                String entityName = entityLivingBase.getCustomNameTag();
                vertical.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.step_height_indicator*} " + (Object)((Object)TextStyleClass.INFO) + stepHeight).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.total_armor_indicator*} " + (Object)((Object)TextStyleClass.INFO) + totalArmorValue).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.age_indicator*} " + (Object)((Object)TextStyleClass.INFO) + age).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.absorption_indicator*} " + (Object)((Object)TextStyleClass.INFO) + absorptionAmount).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.ai_move_speed_indicator*} " + (Object)((Object)TextStyleClass.INFO) + aiMoveSpeed).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.revenge_timer_indicator*} " + (Object)((Object)TextStyleClass.INFO) + revengeTimer).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.on_fire_indicator*} " + (Object)((Object)TextStyleClass.INFO) + isOnFire).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.position_indicator*} " + (Object)((Object)TextStyleClass.INFO) + String.format("X: %.2f, Y: %.2f, Z: %.2f", posX, posY, posZ)).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.motion_indicator*} " + (Object)((Object)TextStyleClass.INFO) + String.format("X: %.2f, Y: %.2f, Z: %.2f", motionX, motionY, motionZ)).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.probe.health_indicator*} " + (Object)((Object)TextStyleClass.INFO) + health + " / " + maxHealth);
                if (Config.showDebugUUID) {
                    vertical.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.uuid_indicator*} " + (Object)((Object)TextStyleClass.INFO) + uuid);
                }
                if (entityLivingBase.hasCustomName()) {
                    vertical.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.custom_name_indicator*} " + (Object)((Object)TextStyleClass.INFO) + entityName);
                }
                if (!activeEffects.isEmpty()) {
                    vertical.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.active_effects_indicator*} ");
                    for (PotionEffect effect : activeEffects) {
                        vertical.text((Object)((Object)TextStyleClass.INFO) + effect.getEffectName() + " (" + effect.getAmplifier() + ") - " + effect.getDuration() + " ticks");
                    }
                }
            }
            if (entity instanceof EntityLiving) {
                EntityLiving entityLiving = (EntityLiving)entity;
                boolean isLeftHanded = entityLiving.isLeftHanded();
                int maxFallHeight = entityLiving.getMaxFallHeight();
                int maxInChunk = entityLiving.getMaxSpawnedInChunk();
                vertical.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.is_left_handed_indicator*} " + (Object)((Object)TextStyleClass.INFO) + isLeftHanded).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.max_fall_height_indicator*} " + (Object)((Object)TextStyleClass.INFO) + maxFallHeight).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.max_spawnable_in_chunk_indicator*} " + (Object)((Object)TextStyleClass.INFO) + maxInChunk);
            }
            if (entity instanceof EntityAgeable) {
                EntityAgeable entityAgeable = (EntityAgeable)entity;
                int growingAge = entityAgeable.getGrowingAge();
                vertical.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.growing_age_indicator*} " + (Object)((Object)TextStyleClass.INFO) + growingAge);
            }
            if (entity instanceof EntityWaterMob) {
                EntityWaterMob entityWaterMob = (EntityWaterMob)entity;
                boolean canBreatheUnderwater = entityWaterMob.canBreatheUnderwater();
                vertical.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.can_breathe_underwater_indicator*} " + (Object)((Object)TextStyleClass.INFO) + canBreatheUnderwater).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.in_water_indicator*} " + (Object)((Object)TextStyleClass.INFO) + entityWaterMob.isInWater());
            }
            if (entity instanceof EntityChicken) {
                EntityChicken entityChicken = (EntityChicken)entity;
                vertical.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.next_egg_in_indicator*} " + (Object)((Object)TextStyleClass.INFO) + entityChicken.timeUntilNextEgg);
            }
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityPlayer = (EntityPlayer)entity;
                int foodLevel = entityPlayer.getFoodStats().getFoodLevel();
                float saturationLevel = entityPlayer.getFoodStats().getSaturationLevel();
                float luck = entityPlayer.getLuck();
                BlockPos bedLocation = entityPlayer.getBedLocation();
                vertical.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.food_level_indicator*} " + (Object)((Object)TextStyleClass.INFO) + foodLevel).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.saturation_level_indicator*} " + (Object)((Object)TextStyleClass.INFO) + saturationLevel).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.luck_indicator*} " + (Object)((Object)TextStyleClass.INFO) + luck).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.bed_location_indicator*} " + (Object)((Object)TextStyleClass.INFO) + bedLocation);
            }
        }
    }
}

