/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import java.util.Collections;
import java.util.Objects;
import mcjty.lib.api.power.IBigPower;
import mcjty.theoneprobe.ClientTools;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IBlockDisplayOverride;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.ProbeConfig;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import mcjty.theoneprobe.apiimpl.providers.ChestInfoTools;
import mcjty.theoneprobe.apiimpl.providers.HarvestInfoTools;
import mcjty.theoneprobe.compat.RedstoneFluxTools;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.setup.ModSetup;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBrewingStand;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class DefaultProbeInfoProvider
implements IProbeInfoProvider {
    private static String cachedBlockName;
    private static String cachedTruncatedBlockName;

    @Override
    public String getID() {
        return "theoneprobe:default";
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        Block block = blockState.getBlock();
        BlockPos pos = data.getPos();
        IProbeConfig config = Config.getRealConfig();
        boolean handled = false;
        for (IBlockDisplayOverride override : TheOneProbe.theOneProbeImp.getBlockOverrides()) {
            if (!override.overrideStandardInfo(mode, probeInfo, player, world, blockState, data)) continue;
            handled = true;
            break;
        }
        if (!handled) {
            DefaultProbeInfoProvider.showStandardBlockInfo(config, mode, probeInfo, blockState, block, data, world);
        }
        if (Tools.show(mode, config.getShowCropPercentage())) {
            this.showGrowthLevel(probeInfo, blockState);
        }
        boolean showHarvestLevel = Tools.show(mode, config.getShowHarvestLevel());
        boolean showHarvested = Tools.show(mode, config.getShowCanBeHarvested());
        if (showHarvested && showHarvestLevel) {
            HarvestInfoTools.showHarvestInfo(probeInfo, world, pos, block, blockState, player);
        } else if (showHarvestLevel) {
            HarvestInfoTools.showHarvestLevel(probeInfo, blockState, block);
        } else if (showHarvested) {
            HarvestInfoTools.showCanBeHarvested(probeInfo, world, pos, block, player);
        }
        if (Tools.show(mode, config.getShowRedstone())) {
            this.showRedstonePower(probeInfo, world, blockState, data, block, Tools.show(mode, config.getShowLeverSetting()));
        }
        if (Tools.show(mode, config.getShowLeverSetting())) {
            this.showLeverSetting(probeInfo, blockState, block);
        }
        ChestInfoTools.showChestInfo(mode, probeInfo, world, pos, config);
        if (config.getRFMode() > 0) {
            this.showRF(probeInfo, world, pos);
        }
        if (Tools.show(mode, config.getShowTankSetting()) && config.getTankMode() > 0) {
            this.showTankInfo(probeInfo, world, pos);
        }
        if (Tools.show(mode, config.getShowBrewStandSetting())) {
            this.showBrewingStandInfo(probeInfo, world, data, block);
        }
        if (Tools.show(mode, config.getShowMobSpawnerSetting())) {
            this.showMobSpawnerInfo(probeInfo, world, data, block);
        }
        if (blockState.getBlock() instanceof BlockCauldron) {
            for (IProperty property : blockState.getProperties().keySet()) {
                if (!"level".equals(property.getName()) || property.getValueClass() != Integer.class) continue;
                IProperty integerProperty = property;
                int fill = (Integer)blockState.getValue(integerProperty);
                if (fill > 0) {
                    probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text((Object)((Object)TextStyleClass.LABEL) + (fill == 1 ? fill + " {*theoneprobe.probe.bottle_indicator*}" : fill + " {*theoneprobe.probe.bottles_indicator*}"));
                } else {
                    probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.probe.empty_indicator*}");
                }
                return;
            }
        }
    }

    private void showBrewingStandInfo(IProbeInfo probeInfo, World world, IProbeHitData data, Block block) {
        TileEntity te;
        if (block instanceof BlockBrewingStand && (te = world.getTileEntity(data.getPos())) instanceof TileEntityBrewingStand) {
            int brewtime = ((TileEntityBrewingStand)te).getField(0);
            int fuel = ((TileEntityBrewingStand)te).getField(1);
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(new ItemStack(Items.BLAZE_POWDER), probeInfo.defaultItemStyle().width(16).height(16)).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.probe.fuel_indicator*} " + (Object)((Object)TextStyleClass.INFO) + fuel);
            if (brewtime > 0) {
                probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.probe.time_indicator*} " + (Object)((Object)TextStyleClass.INFO) + brewtime + " ticks");
            }
        }
    }

    private void showMobSpawnerInfo(IProbeInfo probeInfo, World world, IProbeHitData data, Block block) {
        TileEntity te;
        if (block instanceof BlockMobSpawner && (te = world.getTileEntity(data.getPos())) instanceof TileEntityMobSpawner) {
            MobSpawnerBaseLogic logic = ((TileEntityMobSpawner)te).getSpawnerBaseLogic();
            String mobName = logic.getCachedEntity().getName();
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.probe.mob_indicator*} " + (Object)((Object)TextStyleClass.INFO) + mobName);
        }
    }

    private void showRedstonePower(IProbeInfo probeInfo, World world, IBlockState blockState, IProbeHitData data, Block block, boolean showLever) {
        if (showLever && block instanceof BlockLever) {
            return;
        }
        int redstonePower = block instanceof BlockRedstoneWire ? ((Integer)blockState.getValue((IProperty)BlockRedstoneWire.POWER)).intValue() : world.getRedstonePower(data.getPos(), data.getSideHit().getOpposite());
        if (redstonePower > 0) {
            probeInfo.horizontal().item(new ItemStack(Items.REDSTONE), probeInfo.defaultItemStyle().width(14).height(14)).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.probe.power_indicator*} " + (Object)((Object)TextStyleClass.INFO) + redstonePower);
        }
    }

    private void showLeverSetting(IProbeInfo probeInfo, IBlockState blockState, Block block) {
        if (block instanceof BlockLever) {
            probeInfo.horizontal().item(new ItemStack(Items.REDSTONE), probeInfo.defaultItemStyle().width(14).height(14)).text((Object)((Object)TextStyleClass.LABEL) + "State: " + (Object)((Object)TextStyleClass.INFO) + ((Boolean)blockState.getValue((IProperty)BlockLever.POWERED) != false ? "On" : "Off"));
        } else if (block instanceof BlockRedstoneComparator) {
            BlockRedstoneComparator.Mode mode = (BlockRedstoneComparator.Mode)blockState.getValue((IProperty)BlockRedstoneComparator.MODE);
            probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Mode: " + (Object)((Object)TextStyleClass.INFO) + mode.getName());
        } else if (block instanceof BlockRedstoneRepeater) {
            Boolean locked = (Boolean)blockState.getValue((IProperty)BlockRedstoneRepeater.LOCKED);
            Integer delay = (Integer)blockState.getValue((IProperty)BlockRedstoneRepeater.DELAY);
            probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Delay: " + (Object)((Object)TextStyleClass.INFO) + delay + " ticks");
            if (locked.booleanValue()) {
                probeInfo.text((Object)((Object)TextStyleClass.INFO) + "Locked");
            }
        }
    }

    private void showTankInfo(IProbeInfo probeInfo, World world, BlockPos pos) {
        IFluidTankProperties[] properties;
        IFluidHandler handler;
        ProbeConfig config = Config.getDefaultConfig();
        TileEntity te = world.getTileEntity(pos);
        if (te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && (handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) != null && (properties = handler.getTankProperties()) != null) {
            for (IFluidTankProperties property : properties) {
                if (property == null) continue;
                FluidStack fluidStack = property.getContents();
                int maxContents = property.getCapacity();
                this.addFluidInfo(probeInfo, config, fluidStack, maxContents);
            }
        }
    }

    private void addFluidInfo(IProbeInfo probeInfo, ProbeConfig config, FluidStack fluidStack, int maxContents) {
        int contents;
        int n = contents = fluidStack == null ? 0 : fluidStack.amount;
        if (fluidStack != null) {
            probeInfo.horizontal().text((Object)((Object)TextStyleClass.NAME) + "Liquid: ").fluidLabel(fluidStack);
        }
        if (config.getTankMode() == 1) {
            probeInfo.progress(contents, maxContents, probeInfo.defaultProgressStyle().suffix("mB").filledColor(Config.tankbarFilledColor).alternateFilledColor(Config.tankbarAlternateFilledColor).borderColor(Config.tankbarBorderColor).numberFormat(Config.tankFormat));
        } else {
            probeInfo.text((Object)((Object)TextStyleClass.PROGRESS) + ElementProgress.format(contents, Config.tankFormat, "mB"));
        }
    }

    private void showRF(IProbeInfo probeInfo, World world, BlockPos pos) {
        IEnergyStorage handler;
        ProbeConfig config = Config.getDefaultConfig();
        TileEntity te = world.getTileEntity(pos);
        if (te instanceof IBigPower) {
            long energy = ((IBigPower)te).getStoredPower();
            long maxEnergy = ((IBigPower)te).getCapacity();
            this.addRFInfo(probeInfo, config, energy, maxEnergy);
        } else if (ModSetup.redstoneflux && RedstoneFluxTools.isEnergyHandler(te)) {
            int energy = RedstoneFluxTools.getEnergy(te);
            int maxEnergy = RedstoneFluxTools.getMaxEnergy(te);
            this.addRFInfo(probeInfo, config, energy, maxEnergy);
        } else if (te != null && te.hasCapability(CapabilityEnergy.ENERGY, null) && (handler = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            this.addRFInfo(probeInfo, config, handler.getEnergyStored(), handler.getMaxEnergyStored());
        }
    }

    private void addRFInfo(IProbeInfo probeInfo, ProbeConfig config, long energy, long maxEnergy) {
        if (config.getRFMode() == 1) {
            probeInfo.progress(energy, maxEnergy, probeInfo.defaultProgressStyle().suffix("RF").filledColor(Config.rfbarFilledColor).alternateFilledColor(Config.rfbarAlternateFilledColor).borderColor(Config.rfbarBorderColor).numberFormat(Config.rfFormat));
        } else {
            probeInfo.text((Object)((Object)TextStyleClass.PROGRESS) + "RF: " + ElementProgress.format(energy, Config.rfFormat, "RF"));
        }
    }

    private void showGrowthLevel(IProbeInfo probeInfo, IBlockState blockState) {
        for (IProperty property : blockState.getProperties().keySet()) {
            if (!"age".equals(property.getName())) continue;
            if (property.getValueClass() == Integer.class) {
                int maxAge;
                IProperty integerProperty = property;
                int age = (Integer)blockState.getValue(integerProperty);
                if (age == (maxAge = ((Integer)Collections.max(integerProperty.getAllowedValues())).intValue())) {
                    probeInfo.text((Object)((Object)TextStyleClass.OK) + "{*theoneprobe.probe.fully_grown_indicator*}");
                } else {
                    probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.probe.growth_indicator*} " + (Object)((Object)TextStyleClass.WARNING) + age * 100 / maxAge + "%");
                }
            }
            return;
        }
    }

    public static void showStandardBlockInfo(IProbeConfig config, ProbeMode mode, IProbeInfo probeInfo, IBlockState blockState, Block block, IProbeHitData data, World world) {
        Fluid fluid;
        String modid = Tools.getModName(block);
        ItemStack pickBlock = data.getPickBlock();
        if (block instanceof BlockSilverfish && mode != ProbeMode.DEBUG && !Tools.show(mode, config.getShowSilverfish())) {
            BlockSilverfish.EnumType type = (BlockSilverfish.EnumType)blockState.getValue((IProperty)BlockSilverfish.VARIANT);
            blockState = type.getModelBlock();
            block = blockState.getBlock();
            pickBlock = new ItemStack(block, 1, block.getMetaFromState(blockState));
        }
        if ((block instanceof BlockFluidBase || block instanceof BlockLiquid) && (fluid = FluidRegistry.lookupFluidForBlock((Block)block)) != null) {
            FluidStack fluidStack = new FluidStack(fluid, 1000);
            ItemStack bucketStack = FluidUtil.getFilledBucket((FluidStack)fluidStack);
            IProbeInfo horizontal = probeInfo.horizontal();
            if (fluidStack.isFluidEqual(FluidUtil.getFluidContained((ItemStack)bucketStack))) {
                horizontal.item(bucketStack);
            } else {
                horizontal.icon(fluid.getStill(), -1, -1, 16, 16, probeInfo.defaultIconStyle().width(20));
            }
            horizontal.vertical().text((Object)((Object)TextStyleClass.NAME) + fluidStack.getLocalizedName()).text((Object)((Object)TextStyleClass.MODNAME) + modid);
            return;
        }
        if (!Objects.requireNonNull(pickBlock).isEmpty()) {
            if (Tools.show(mode, config.getShowModName())) {
                String blockDisplayName = pickBlock.getDisplayName();
                if (Config.getBlockNameMaxWidth() != 0.0f) {
                    FontRenderer fontRenderer = ClientTools.mc.fontRenderer;
                    int screenWidth = Tools.getScreenWidth();
                    int availableWidth = (int)((float)screenWidth * Config.getBlockNameMaxWidth());
                    if (blockDisplayName.equals(cachedBlockName)) {
                        blockDisplayName = cachedTruncatedBlockName;
                    } else if (fontRenderer.getStringWidth(blockDisplayName) > availableWidth) {
                        int charWidth = fontRenderer.getCharWidth(blockDisplayName.charAt(0));
                        int index = availableWidth / charWidth - 1;
                        index = Math.max(index, 0);
                        String truncated = null;
                        boolean quit = false;
                        while (!quit) {
                            truncated = blockDisplayName.substring(0, index);
                            int width = fontRenderer.getStringWidth(truncated);
                            int nextWidth = fontRenderer.getStringWidth(blockDisplayName.substring(0, index + 1));
                            if (width <= availableWidth && nextWidth > availableWidth || width == availableWidth) {
                                quit = true;
                                continue;
                            }
                            if (width > availableWidth) {
                                index /= 2;
                                continue;
                            }
                            ++index;
                        }
                        cachedBlockName = blockDisplayName;
                        cachedTruncatedBlockName = blockDisplayName = truncated + "...";
                    } else {
                        cachedBlockName = blockDisplayName;
                        cachedTruncatedBlockName = blockDisplayName;
                    }
                }
                probeInfo.horizontal().item(pickBlock).vertical().text((Object)((Object)TextStyleClass.NAME) + blockDisplayName).text((Object)((Object)TextStyleClass.MODNAME) + modid);
            } else {
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(pickBlock).itemLabel(pickBlock);
            }
        } else if (Tools.show(mode, config.getShowModName())) {
            probeInfo.vertical().text((Object)((Object)TextStyleClass.MODNAME) + modid);
        }
    }
}

