/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.gui;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import mcjty.theoneprobe.api.TextStyleClass;
import org.apache.commons.lang3.tuple.Pair;

public class Preset {
    private final String name;
    private final int boxBorderColor;
    private final int boxFillColor;
    private final int boxThickness;
    private final int boxOffset;
    private final Map<TextStyleClass, String> textStyleClasses;

    @SafeVarargs
    public Preset(String name, int boxBorderColor, int boxFillColor, int boxThickness, int boxOffset, Pair<TextStyleClass, String> ... styles) {
        this.name = name;
        this.boxBorderColor = boxBorderColor;
        this.boxFillColor = boxFillColor;
        this.boxThickness = boxThickness;
        this.boxOffset = boxOffset;
        this.textStyleClasses = new HashMap<TextStyleClass, String>();
        for (Pair<TextStyleClass, String> style : styles) {
            this.textStyleClasses.put((TextStyleClass)((Object)style.getLeft()), (String)style.getRight());
        }
    }

    public Collection<TextStyleClass> getTextStyleClassKeys() {
        return this.textStyleClasses.keySet();
    }

    public String getStyleName(TextStyleClass styleClass) {
        return this.textStyleClasses.get((Object)styleClass);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getBoxBorderColor() {
        return this.boxBorderColor;
    }

    @Generated
    public int getBoxFillColor() {
        return this.boxFillColor;
    }

    @Generated
    public int getBoxThickness() {
        return this.boxThickness;
    }

    @Generated
    public int getBoxOffset() {
        return this.boxOffset;
    }

    @Generated
    public Map<TextStyleClass, String> getTextStyleClasses() {
        return this.textStyleClasses;
    }
}

