/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;

public class NetworkTools {
    public static NBTTagCompound readNBT(ByteBuf dataIn) {
        PacketBuffer buf = new PacketBuffer(dataIn);
        try {
            return buf.readCompoundTag();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeNBT(ByteBuf dataOut, NBTTagCompound nbt) {
        PacketBuffer buf = new PacketBuffer(dataOut);
        try {
            buf.writeCompoundTag(nbt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ItemStack readItemStack(ByteBuf dataIn) {
        PacketBuffer buf = new PacketBuffer(dataIn);
        try {
            NBTTagCompound nbt = buf.readCompoundTag();
            ItemStack stack = new ItemStack(Objects.requireNonNull(nbt));
            stack.setCount(buf.readInt());
            return stack;
        }
        catch (IOException e) {
            e.printStackTrace();
            return ItemStack.EMPTY;
        }
    }

    public static void writeItemStack(ByteBuf dataOut, ItemStack itemStack) {
        PacketBuffer buf = new PacketBuffer(dataOut);
        NBTTagCompound nbt = new NBTTagCompound();
        itemStack.writeToNBT(nbt);
        try {
            buf.writeCompoundTag(nbt);
            buf.writeInt(itemStack.getCount());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeStringCompact(ByteBuf buf, String str) {
        if (str == null) {
            NetworkTools.writeVarInt(buf, -1);
            return;
        }
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        NetworkTools.writeVarInt(buf, bytes.length);
        buf.writeBytes(bytes);
    }

    public static String readStringCompact(ByteBuf buf) {
        int length = NetworkTools.readVarInt(buf);
        if (length == -1) {
            return null;
        }
        if (length == 0) {
            return "";
        }
        byte[] bytes = new byte[length];
        buf.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Deprecated
    public static void writeString(ByteBuf buf, String str) {
        NetworkTools.writeStringCompact(buf, str);
    }

    @Deprecated
    public static void writeStringUTF8(ByteBuf buf, String str) {
        NetworkTools.writeStringCompact(buf, str);
    }

    @Deprecated
    public static String readString(ByteBuf buf) {
        return NetworkTools.readStringCompact(buf);
    }

    @Deprecated
    public static String readStringUTF8(ByteBuf buf) {
        return NetworkTools.readStringCompact(buf);
    }

    public static BlockPos readPos(ByteBuf dataIn) {
        return new BlockPos(dataIn.readInt(), dataIn.readInt(), dataIn.readInt());
    }

    public static void writePos(ByteBuf dataOut, BlockPos pos) {
        dataOut.writeInt(pos.getX());
        dataOut.writeInt(pos.getY());
        dataOut.writeInt(pos.getZ());
    }

    public static <T extends Enum<T>> void writeEnum(ByteBuf buf, T value, T nullValue) {
        if (value == null) {
            buf.writeInt(nullValue.ordinal());
        } else {
            buf.writeInt(value.ordinal());
        }
    }

    public static <T extends Enum<T>> T readEnum(ByteBuf buf, T[] values) {
        return values[buf.readInt()];
    }

    public static <T extends Enum<T>> void writeEnumCollection(ByteBuf buf, Collection<T> collection) {
        buf.writeInt(collection.size());
        for (Enum type : collection) {
            buf.writeInt(type.ordinal());
        }
    }

    public static <T extends Enum<T>> void readEnumCollection(ByteBuf buf, Collection<T> collection, T[] values) {
        collection.clear();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            collection.add(values[buf.readInt()]);
        }
    }

    public static void writeFloat(ByteBuf buf, @Nullable Float value) {
        if (value != null) {
            buf.writeBoolean(true);
            buf.writeFloat(value.floatValue());
        } else {
            buf.writeBoolean(false);
        }
    }

    public static Float readFloat(ByteBuf buf) {
        if (buf.readBoolean()) {
            return Float.valueOf(buf.readFloat());
        }
        return null;
    }

    public static void writeVarInt(ByteBuf buf, int value) {
        while ((long)(value & 0xFFFFFF80) != 0L) {
            buf.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        buf.writeByte(value & 0x7F);
    }

    public static int readVarInt(ByteBuf buf) {
        byte read;
        int numRead = 0;
        int result = 0;
        do {
            read = buf.readByte();
            result |= (read & 0x7F) << 7 * numRead;
            if (++numRead <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((read & 0x80) != 0);
        return result;
    }
}

