/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.rendering;

import javax.annotation.Nullable;
import mcjty.theoneprobe.ClientTools;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.network.ThrowableIdentity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;

public class RenderHelper {
    public static float rot = 0.0f;

    public static void renderEntity(Entity entity, int xPos, int yPos, float scale) {
        GlStateManager.pushMatrix();
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableColorMaterial();
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)(xPos + 8), (float)(yPos + 24), (float)50.0f);
        GlStateManager.scale((float)(-scale), (float)scale, (float)scale);
        GlStateManager.rotate((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.rotate((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        net.minecraft.client.renderer.RenderHelper.enableStandardItemLighting();
        GlStateManager.rotate((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotate((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotate((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        entity.rotationPitch = 0.0f;
        GlStateManager.translate((float)0.0f, (float)((float)entity.getYOffset() + (entity instanceof EntityHanging ? 0.5f : 0.0f)), (float)0.0f);
        ClientTools.mc.getRenderManager().playerViewY = 180.0f;
        try {
            ClientTools.mc.getRenderManager().renderEntity(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        }
        catch (Exception e) {
            TheOneProbe.setup.getLogger().error("Error rendering entity!", (Throwable)e);
        }
        GlStateManager.popMatrix();
        net.minecraft.client.renderer.RenderHelper.disableStandardItemLighting();
        GlStateManager.disableRescaleNormal();
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.disableLighting();
        GlStateManager.popMatrix();
        GlStateManager.enableDepth();
        GlStateManager.disableColorMaterial();
        GlStateManager.setActiveTexture((int)OpenGlHelper.lightmapTexUnit);
        GlStateManager.disableTexture2D();
        GlStateManager.setActiveTexture((int)OpenGlHelper.defaultTexUnit);
    }

    public static boolean renderItemStackWithCount(Minecraft mc, RenderItem itemRender, ItemStack itm, int xo, int yo, boolean highlight) {
        if (itm.getCount() <= 1) {
            return RenderHelper.renderItemStack(mc, itemRender, itm, xo, yo, "", highlight);
        }
        return RenderHelper.renderItemStack(mc, itemRender, itm, xo, yo, "" + itm.getCount(), highlight);
    }

    public static boolean renderItemStack(Minecraft mc, RenderItem itemRender, ItemStack itm, int x, int y, String txt, boolean highlight) {
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f);
        boolean rc = false;
        if (highlight) {
            GlStateManager.disableLighting();
            RenderHelper.drawGradientRect(x, y, x + 16, y + 16, -2130706433, -1, true);
        }
        if (!itm.isEmpty()) {
            rc = true;
            GlStateManager.pushMatrix();
            GlStateManager.translate((float)0.0f, (float)0.0f, (float)32.0f);
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.enableRescaleNormal();
            GlStateManager.enableLighting();
            int short1 = 240;
            int short2 = 240;
            net.minecraft.client.renderer.RenderHelper.enableGUIStandardItemLighting();
            OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)short1, (float)short2);
            itemRender.renderItemAndEffectIntoGUI(itm, x, y);
            itemRender.renderItemOverlayIntoGUI(mc.fontRenderer, itm, x, y, txt);
            GlStateManager.popMatrix();
            GlStateManager.disableRescaleNormal();
            GlStateManager.disableLighting();
        }
        return rc;
    }

    public static void drawGradientRect(int x1, int y1, int x2, int y2, int color1, int color2, boolean isVertical) {
        float zLevel = 0.0f;
        float a1 = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float r1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(color1 & 0xFF) / 255.0f;
        float a2 = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float r2 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(color2 & 0xFF) / 255.0f;
        GlStateManager.disableTexture2D();
        GlStateManager.enableBlend();
        GlStateManager.disableAlpha();
        OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
        GlStateManager.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder buffer = tessellator.getBuffer();
        buffer.begin(7, DefaultVertexFormats.POSITION_COLOR);
        if (isVertical) {
            buffer.pos((double)x2, (double)y1, (double)zLevel).color(r1, g1, b1, a1).endVertex();
            buffer.pos((double)x1, (double)y1, (double)zLevel).color(r1, g1, b1, a1).endVertex();
            buffer.pos((double)x1, (double)y2, (double)zLevel).color(r2, g2, b2, a2).endVertex();
            buffer.pos((double)x2, (double)y2, (double)zLevel).color(r2, g2, b2, a2).endVertex();
        } else {
            buffer.pos((double)x1, (double)y1, (double)zLevel).color(r1, g1, b1, a1).endVertex();
            buffer.pos((double)x1, (double)y2, (double)zLevel).color(r1, g1, b1, a1).endVertex();
            buffer.pos((double)x2, (double)y2, (double)zLevel).color(r2, g2, b2, a2).endVertex();
            buffer.pos((double)x2, (double)y1, (double)zLevel).color(r2, g2, b2, a2).endVertex();
        }
        tessellator.draw();
        GlStateManager.shadeModel((int)7424);
        GlStateManager.disableBlend();
        GlStateManager.enableAlpha();
        GlStateManager.enableTexture2D();
    }

    @Deprecated
    public static void drawVerticalLine(int x1, int y1, int y2, int color) {
        Gui.drawRect((int)x1, (int)y1, (int)(x1 + 1), (int)y2, (int)color);
    }

    @Deprecated
    public static void drawHorizontalLine(int x1, int y1, int x2, int color) {
        Gui.drawRect((int)x1, (int)y1, (int)x2, (int)(y1 + 1), (int)color);
    }

    public static void drawLine(int x1, int y1, int x2, int y2, int color, int thickness, String orientation) {
        switch (orientation.toLowerCase()) {
            case "vertical": {
                Gui.drawRect((int)x1, (int)y1, (int)(x1 + thickness), (int)y2, (int)color);
                break;
            }
            case "horizontal": {
                Gui.drawRect((int)x1, (int)y1, (int)x2, (int)(y1 + thickness), (int)color);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid orientation: " + orientation);
            }
        }
    }

    public static void drawTriangle(int x, int y, int color, String direction) {
        switch (direction.toLowerCase()) {
            case "left": {
                RenderHelper.drawLine(x, y, x + 2, y, color, 1, "vertical");
                RenderHelper.drawLine(x + 1, y - 1, x + 1, y + 1, color, 1, "vertical");
                RenderHelper.drawLine(x + 2, y - 2, x + 2, y + 2, color, 1, "vertical");
                break;
            }
            case "right": {
                RenderHelper.drawLine(x, y, x - 2, y, color, 1, "vertical");
                RenderHelper.drawLine(x - 1, y - 1, x - 1, y + 1, color, 1, "vertical");
                RenderHelper.drawLine(x - 2, y - 2, x - 2, y + 2, color, 1, "vertical");
                break;
            }
            case "up": {
                RenderHelper.drawLine(x, y, x, y + 2, color, 1, "horizontal");
                RenderHelper.drawLine(x - 1, y + 1, x + 1, y + 1, color, 1, "horizontal");
                RenderHelper.drawLine(x - 2, y + 2, x + 2, y + 2, color, 1, "horizontal");
                break;
            }
            case "down": {
                RenderHelper.drawLine(x, y, x, y - 2, color, 1, "horizontal");
                RenderHelper.drawLine(x - 1, y - 1, x + 1, y - 1, color, 1, "horizontal");
                RenderHelper.drawLine(x - 2, y - 2, x + 2, y - 2, color, 1, "horizontal");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid direction: " + direction);
            }
        }
    }

    public static void drawFlatButtonBox(int x1, int y1, int x2, int y2, int bright, int average, int dark) {
        RenderHelper.drawBeveledBox(x1, y1, x2, y2, bright, dark, average);
    }

    public static void drawFlatButtonBoxGradient(int x1, int y1, int x2, int y2, int bright, int average1, int average2, int dark) {
        RenderHelper.drawGradientRect(x1 + 1, y1 + 1, x2 - 1, y2 - 1, average2, average1, true);
        RenderHelper.drawLine(x1, y1, x2 - 1, y1, bright, 1, "horizontal");
        RenderHelper.drawLine(x1, y1, x1, y2 - 1, bright, 1, "vertical");
        RenderHelper.drawLine(x2 - 1, y1, x2 - 1, y2 - 1, dark, 1, "vertical");
        RenderHelper.drawLine(x1, y2 - 1, x2, y2 - 1, dark, 1, "horizontal");
    }

    public static void drawBeveledBox(int x1, int y1, int x2, int y2, int topleftcolor, int botrightcolor, int fillcolor) {
        if (fillcolor != -1) {
            Gui.drawRect((int)(x1 + 1), (int)(y1 + 1), (int)(x2 - 1), (int)(y2 - 1), (int)fillcolor);
        }
        RenderHelper.drawLine(x1, y1, x2 - 1, y1, topleftcolor, 1, "horizontal");
        RenderHelper.drawLine(x1, y1, x1, y2 - 1, topleftcolor, 1, "vertical");
        RenderHelper.drawLine(x2 - 1, y1, x2 - 1, y2 - 1, botrightcolor, 1, "vertical");
        RenderHelper.drawLine(x1, y2 - 1, x2, y2 - 1, botrightcolor, 1, "horizontal");
    }

    public static void drawThickBeveledBox(int x1, int y1, int x2, int y2, int thickness, int topleftcolor, int botrightcolor, int fillcolor) {
        if (fillcolor != -1) {
            Gui.drawRect((int)(x1 + 1), (int)(y1 + 1), (int)(x2 - 1), (int)(y2 - 1), (int)fillcolor);
        }
        Gui.drawRect((int)x1, (int)y1, (int)(x2 - 1), (int)(y1 + thickness), (int)topleftcolor);
        Gui.drawRect((int)x1, (int)y1, (int)(x1 + thickness), (int)(y2 - 1), (int)topleftcolor);
        Gui.drawRect((int)(x2 - thickness), (int)y1, (int)x2, (int)(y2 - 1), (int)botrightcolor);
        Gui.drawRect((int)x1, (int)(y2 - thickness), (int)x2, (int)y2, (int)botrightcolor);
    }

    public static void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, int twidth, int theight) {
        float zLevel = 0.01f;
        float f = 1.0f / (float)twidth;
        float f1 = 1.0f / (float)theight;
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder buffer = tessellator.getBuffer();
        buffer.begin(7, DefaultVertexFormats.POSITION_TEX);
        buffer.pos((double)x, (double)(y + height), (double)zLevel).tex((double)((float)u * f), (double)((float)(v + height) * f1)).endVertex();
        buffer.pos((double)(x + width), (double)(y + height), (double)zLevel).tex((double)((float)(u + width) * f), (double)((float)(v + height) * f1)).endVertex();
        buffer.pos((double)(x + width), (double)y, (double)zLevel).tex((double)((float)(u + width) * f), (double)((float)v * f1)).endVertex();
        buffer.pos((double)x, (double)y, (double)zLevel).tex((double)((float)u * f), (double)((float)v * f1)).endVertex();
        tessellator.draw();
    }

    public static void drawTexturedModalRect(int x, int y, int u, int v, int width, int height) {
        float zLevel = 0.01f;
        float textureScaleX = 0.00390625f;
        float textureScaleY = 0.00390625f;
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder buffer = tessellator.getBuffer();
        buffer.begin(7, DefaultVertexFormats.POSITION_TEX);
        buffer.pos((double)x, (double)(y + height), (double)zLevel).tex((double)((float)u * textureScaleX), (double)((float)(v + height) * textureScaleY)).endVertex();
        buffer.pos((double)(x + width), (double)(y + height), (double)zLevel).tex((double)((float)(u + width) * textureScaleX), (double)((float)(v + height) * textureScaleY)).endVertex();
        buffer.pos((double)(x + width), (double)y, (double)zLevel).tex((double)((float)(u + width) * textureScaleX), (double)((float)v * textureScaleY)).endVertex();
        buffer.pos((double)x, (double)y, (double)zLevel).tex((double)((float)u * textureScaleX), (double)((float)v * textureScaleY)).endVertex();
        tessellator.draw();
    }

    public static void drawTexturedModalRect(int x, int y, TextureAtlasSprite sprite, int width, int height) {
        float zLevel = 0.01f;
        float u1 = sprite.getMinU();
        float v1 = sprite.getMinV();
        float u2 = sprite.getMaxU();
        float v2 = sprite.getMaxV();
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder buffer = tessellator.getBuffer();
        buffer.begin(7, DefaultVertexFormats.POSITION_TEX);
        buffer.pos((double)x, (double)(y + height), (double)zLevel).tex((double)u1, (double)v1).endVertex();
        buffer.pos((double)(x + width), (double)(y + height), (double)zLevel).tex((double)u1, (double)v2).endVertex();
        buffer.pos((double)(x + width), (double)y, (double)zLevel).tex((double)u2, (double)v2).endVertex();
        buffer.pos((double)x, (double)y, (double)zLevel).tex((double)u2, (double)v1).endVertex();
        tessellator.draw();
    }

    public static void renderBillboardQuadBright(double scale) {
        int brightness = 240;
        int b1 = brightness >> 16 & 0xFFFF;
        int b2 = brightness & 0xFFFF;
        GlStateManager.pushMatrix();
        RenderHelper.rotateToPlayer();
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder buffer = tessellator.getBuffer();
        buffer.begin(7, DefaultVertexFormats.POSITION_TEX_LMAP_COLOR);
        buffer.pos(-scale, -scale, 0.0).tex(0.0, 0.0).lightmap(b1, b2).color(255, 255, 255, 128).endVertex();
        buffer.pos(-scale, scale, 0.0).tex(0.0, 1.0).lightmap(b1, b2).color(255, 255, 255, 128).endVertex();
        buffer.pos(scale, scale, 0.0).tex(1.0, 1.0).lightmap(b1, b2).color(255, 255, 255, 128).endVertex();
        buffer.pos(scale, -scale, 0.0).tex(1.0, 0.0).lightmap(b1, b2).color(255, 255, 255, 128).endVertex();
        tessellator.draw();
        GlStateManager.popMatrix();
    }

    public static void renderBillboardQuad(double scale) {
        GlStateManager.pushMatrix();
        RenderHelper.rotateToPlayer();
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder buffer = tessellator.getBuffer();
        buffer.begin(7, DefaultVertexFormats.POSITION_TEX);
        buffer.pos(-scale, -scale, 0.0).tex(0.0, 0.0).endVertex();
        buffer.pos(-scale, scale, 0.0).tex(0.0, 1.0).endVertex();
        buffer.pos(scale, scale, 0.0).tex(1.0, 1.0).endVertex();
        buffer.pos(scale, -scale, 0.0).tex(1.0, 0.0).endVertex();
        tessellator.draw();
        GlStateManager.popMatrix();
    }

    public static void renderBillboardQuadWithRotation(float rot, double scale) {
        GlStateManager.pushMatrix();
        RenderHelper.rotateToPlayer();
        GlStateManager.rotate((float)rot, (float)0.0f, (float)0.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder buffer = tessellator.getBuffer();
        buffer.begin(7, DefaultVertexFormats.POSITION_TEX);
        buffer.pos(-scale, -scale, 0.0).tex(0.0, 0.0).endVertex();
        buffer.pos(-scale, scale, 0.0).tex(0.0, 1.0).endVertex();
        buffer.pos(scale, scale, 0.0).tex(1.0, 1.0).endVertex();
        buffer.pos(scale, -scale, 0.0).tex(1.0, 0.0).endVertex();
        tessellator.draw();
        GlStateManager.popMatrix();
    }

    public static void rotateToPlayer() {
        GlStateManager.rotate((float)(-ClientTools.mc.getRenderManager().playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotate((float)ClientTools.mc.getRenderManager().playerViewX, (float)1.0f, (float)0.0f, (float)0.0f);
    }

    public static void drawBeam(Vec3d S, Vec3d E, Vec3d P, float width) {
        Vec3d PS = RenderHelper.Sub(S, P);
        Vec3d SE = RenderHelper.Sub(E, S);
        Vec3d normal = RenderHelper.Cross(PS, SE);
        normal = normal.normalize();
        Vec3d half = RenderHelper.Mul(normal, width);
        Vec3d p1 = RenderHelper.Add(S, half);
        Vec3d p2 = RenderHelper.Sub(S, half);
        Vec3d p3 = RenderHelper.Add(E, half);
        Vec3d p4 = RenderHelper.Sub(E, half);
        RenderHelper.drawQuad(Tessellator.getInstance(), p1, p3, p4, p2);
    }

    private static void drawQuad(Tessellator tessellator, Vec3d p1, Vec3d p2, Vec3d p3, Vec3d p4) {
        int brightness = 240;
        int b1 = 0;
        int b2 = brightness & 0xFFFF;
        BufferBuilder buffer = tessellator.getBuffer();
        buffer.begin(7, DefaultVertexFormats.POSITION_TEX_LMAP_COLOR);
        buffer.pos(p1.x, p1.y, p1.z).tex(0.0, 0.0).lightmap(b1, b2).color(255, 255, 255, 128).endVertex();
        buffer.pos(p2.x, p2.y, p2.z).tex(1.0, 0.0).lightmap(b1, b2).color(255, 255, 255, 128).endVertex();
        buffer.pos(p3.x, p3.y, p3.z).tex(1.0, 1.0).lightmap(b1, b2).color(255, 255, 255, 128).endVertex();
        buffer.pos(p4.x, p4.y, p4.z).tex(0.0, 1.0).lightmap(b1, b2).color(255, 255, 255, 128).endVertex();
        tessellator.draw();
    }

    public static boolean renderItemStack(Minecraft mc, RenderItem itemRender, ItemStack itm, int x, int y, String txt) {
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f);
        boolean rc = true;
        if (!itm.isEmpty() && itm.getItem() != null) {
            GlStateManager.pushMatrix();
            GlStateManager.translate((float)0.0f, (float)0.0f, (float)32.0f);
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.enableRescaleNormal();
            GlStateManager.enableLighting();
            int short1 = 240;
            int short2 = 240;
            net.minecraft.client.renderer.RenderHelper.enableGUIStandardItemLighting();
            OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)short1, (float)short2);
            try {
                itemRender.renderItemAndEffectIntoGUI(itm, x, y);
                RenderHelper.renderItemOverlayIntoGUI(mc.fontRenderer, itm, x, y, txt, txt.length() - 2);
            }
            catch (Exception e) {
                ThrowableIdentity.registerThrowable(e);
                rc = false;
            }
            GlStateManager.popMatrix();
            GlStateManager.disableRescaleNormal();
            GlStateManager.disableLighting();
        }
        return rc;
    }

    public static void renderItemOverlayIntoGUI(FontRenderer fr, ItemStack stack, int xPosition, int yPosition, @Nullable String text, int scaled) {
        if (!stack.isEmpty()) {
            EntityPlayerSP entityplayersp;
            float f;
            if (stack.getCount() != 1 || text != null) {
                String s;
                String string = s = text == null ? String.valueOf(stack.getCount()) : text;
                if (text == null && stack.getCount() < 1) {
                    s = TextFormatting.RED + String.valueOf(stack.getCount());
                }
                GlStateManager.disableLighting();
                GlStateManager.disableDepth();
                GlStateManager.disableBlend();
                if (scaled >= 2) {
                    GlStateManager.pushMatrix();
                    GlStateManager.scale((float)0.5f, (float)0.5f, (float)0.5f);
                    fr.drawStringWithShadow(s, (float)((xPosition + 19 - 2) * 2 - 1 - fr.getStringWidth(s)), (float)(yPosition * 2 + 24), 0xFFFFFF);
                    GlStateManager.popMatrix();
                } else if (scaled == 1) {
                    GlStateManager.pushMatrix();
                    GlStateManager.scale((float)0.75f, (float)0.75f, (float)0.75f);
                    fr.drawStringWithShadow(s, (float)(xPosition - 2) * 1.34f + 24.0f - (float)fr.getStringWidth(s), (float)yPosition * 1.34f + 14.0f, 0xFFFFFF);
                    GlStateManager.popMatrix();
                } else {
                    fr.drawStringWithShadow(s, (float)(xPosition + 19 - 2 - fr.getStringWidth(s)), (float)(yPosition + 6 + 3), 0xFFFFFF);
                }
                GlStateManager.enableLighting();
                GlStateManager.enableDepth();
                GlStateManager.enableBlend();
            }
            if (stack.getItem().showDurabilityBar(stack)) {
                double health = stack.getItem().getDurabilityForDisplay(stack);
                int j = (int)Math.round(13.0 - health * 13.0);
                int i = (int)Math.round(255.0 - health * 255.0);
                GlStateManager.disableLighting();
                GlStateManager.disableDepth();
                GlStateManager.disableTexture2D();
                GlStateManager.disableAlpha();
                GlStateManager.disableBlend();
                Tessellator tessellator = Tessellator.getInstance();
                BufferBuilder vertexbuffer = tessellator.getBuffer();
                RenderHelper.draw(vertexbuffer, xPosition + 2, yPosition + 13, 13, 2, 0, 0, 0, 255);
                RenderHelper.draw(vertexbuffer, xPosition + 2, yPosition + 13, 12, 1, (255 - i) / 4, 64, 0, 255);
                RenderHelper.draw(vertexbuffer, xPosition + 2, yPosition + 13, j, 1, 255 - i, i, 0, 255);
                GlStateManager.enableBlend();
                GlStateManager.enableAlpha();
                GlStateManager.enableTexture2D();
                GlStateManager.enableLighting();
                GlStateManager.enableDepth();
            }
            float f2 = f = (entityplayersp = ClientTools.mc.player) == null ? 0.0f : entityplayersp.getCooldownTracker().getCooldown(stack.getItem(), ClientTools.mc.getRenderPartialTicks());
            if (f > 0.0f) {
                GlStateManager.disableLighting();
                GlStateManager.disableDepth();
                GlStateManager.disableTexture2D();
                Tessellator tessellator1 = Tessellator.getInstance();
                BufferBuilder vertexbuffer1 = tessellator1.getBuffer();
                RenderHelper.draw(vertexbuffer1, xPosition, yPosition + (int)Math.floor(16.0f * (1.0f - f)), 16, (int)Math.ceil(16.0f * f), 255, 255, 255, 127);
                GlStateManager.enableTexture2D();
                GlStateManager.enableLighting();
                GlStateManager.enableDepth();
            }
        }
    }

    private static void draw(BufferBuilder renderer, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        renderer.begin(7, DefaultVertexFormats.POSITION_COLOR);
        renderer.pos((double)x, (double)y, 0.0).color(red, green, blue, alpha).endVertex();
        renderer.pos((double)x, (double)(y + height), 0.0).color(red, green, blue, alpha).endVertex();
        renderer.pos((double)(x + width), (double)(y + height), 0.0).color(red, green, blue, alpha).endVertex();
        renderer.pos((double)(x + width), (double)y, 0.0).color(red, green, blue, alpha).endVertex();
        Tessellator.getInstance().draw();
    }

    public static int renderText(Minecraft mc, int x, int y, String txt) {
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)0.0f, (float)0.0f, (float)32.0f);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableLighting();
        net.minecraft.client.renderer.RenderHelper.enableGUIStandardItemLighting();
        GlStateManager.disableLighting();
        GlStateManager.disableDepth();
        GlStateManager.disableBlend();
        int width = mc.fontRenderer.getStringWidth(txt);
        mc.fontRenderer.drawStringWithShadow(txt, (float)x, (float)y, 0xFFFFFF);
        GlStateManager.enableLighting();
        GlStateManager.enableDepth();
        GlStateManager.enableBlend();
        GlStateManager.popMatrix();
        GlStateManager.disableRescaleNormal();
        GlStateManager.disableLighting();
        return width;
    }

    private static Vec3d Cross(Vec3d a, Vec3d b) {
        double x = a.y * b.z - a.z * b.y;
        double y = a.z * b.x - a.x * b.z;
        double z = a.x * b.y - a.y * b.x;
        return new Vec3d(x, y, z);
    }

    private static Vec3d Sub(Vec3d a, Vec3d b) {
        return a.subtract(b);
    }

    private static Vec3d Add(Vec3d a, Vec3d b) {
        return a.add(b);
    }

    private static Vec3d Mul(Vec3d a, double f) {
        return a.scale(f);
    }
}

