/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.setup;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.apiimpl.TheOneProbeImp;
import mcjty.theoneprobe.apiimpl.providers.BlockProbeInfoProvider;
import mcjty.theoneprobe.apiimpl.providers.ChestHorseInfoProvider;
import mcjty.theoneprobe.apiimpl.providers.DebugProbeInfoEntityProvider;
import mcjty.theoneprobe.apiimpl.providers.DebugProbeInfoProvider;
import mcjty.theoneprobe.apiimpl.providers.DefaultProbeInfoEntityProvider;
import mcjty.theoneprobe.apiimpl.providers.DefaultProbeInfoProvider;
import mcjty.theoneprobe.apiimpl.providers.EnchantingPowerInfoProvider;
import mcjty.theoneprobe.apiimpl.providers.EntityProbeInfoEntityProvider;
import mcjty.theoneprobe.apiimpl.providers.HorseInfoProvider;
import mcjty.theoneprobe.apiimpl.providers.JukeboxProvider;
import mcjty.theoneprobe.apiimpl.providers.MinecartInfoProvider;
import mcjty.theoneprobe.apiimpl.providers.PaintingInfoProvider;
import mcjty.theoneprobe.apiimpl.providers.PlayerInfoProvider;
import mcjty.theoneprobe.apiimpl.providers.TNTInfoProvider;
import mcjty.theoneprobe.apiimpl.providers.VillagerProbeInfoProvider;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.event.CommonForgeEventHandlers;
import mcjty.theoneprobe.network.PacketHandler;
import mcjty.theoneprobe.playerdata.PlayerGotNote;
import mcjty.theoneprobe.setup.proxy.GuiProxy;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class ModSetup {
    private Logger logger;
    public static File modConfigDir;
    public static boolean baubles;
    public static boolean redstoneflux;

    public void preInit(FMLPreInitializationEvent e) {
        this.logger = e.getModLog();
        MinecraftForge.EVENT_BUS.register((Object)new CommonForgeEventHandlers());
        ModSetup.registerCapabilities();
        TheOneProbeImp.registerElements();
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"Loading Providers", (int)2);
        bar.step("Loading Block Providers");
        TheOneProbe.theOneProbeImp.registerProvider(new DefaultProbeInfoProvider());
        TheOneProbe.theOneProbeImp.registerProvider(new DebugProbeInfoProvider());
        TheOneProbe.theOneProbeImp.registerProvider(new BlockProbeInfoProvider());
        TheOneProbe.theOneProbeImp.registerProvider(new EnchantingPowerInfoProvider());
        TheOneProbe.theOneProbeImp.registerProvider(new JukeboxProvider());
        bar.step("Loading Entity Providers");
        TheOneProbe.theOneProbeImp.registerEntityProvider(new DefaultProbeInfoEntityProvider());
        TheOneProbe.theOneProbeImp.registerEntityProvider(new DebugProbeInfoEntityProvider());
        TheOneProbe.theOneProbeImp.registerEntityProvider(new EntityProbeInfoEntityProvider());
        TheOneProbe.theOneProbeImp.registerEntityProvider(new ChestHorseInfoProvider());
        TheOneProbe.theOneProbeImp.registerEntityProvider(new MinecartInfoProvider());
        TheOneProbe.theOneProbeImp.registerEntityProvider(new TNTInfoProvider());
        TheOneProbe.theOneProbeImp.registerEntityProvider(new PaintingInfoProvider());
        TheOneProbe.theOneProbeImp.registerEntityProvider(new HorseInfoProvider());
        TheOneProbe.theOneProbeImp.registerEntityProvider(new VillagerProbeInfoProvider());
        TheOneProbe.theOneProbeImp.registerEntityProvider(new PlayerInfoProvider());
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
        modConfigDir = e.getModConfigurationDirectory();
        Config.init();
        PacketHandler.registerMessages("theoneprobe");
        this.setupModCompat();
    }

    public Logger getLogger() {
        return this.logger;
    }

    private void setupModCompat() {
        redstoneflux = Loader.isModLoaded((String)"redstoneflux");
        if (redstoneflux) {
            this.logger.log(Level.INFO, "The One Probe Detected RedstoneFlux: enabling support");
        }
        boolean bl = baubles = Loader.isModLoaded((String)"Baubles") || Loader.isModLoaded((String)"baubles");
        if (baubles) {
            if (Config.supportBaubles) {
                this.logger.log(Level.INFO, "The One Probe Detected Baubles: enabling support");
            } else {
                this.logger.log(Level.INFO, "The One Probe Detected Baubles, but support is disabled in config");
                baubles = false;
            }
        }
    }

    private static void registerCapabilities() {
        CapabilityManager.INSTANCE.register(PlayerGotNote.class, (Capability.IStorage)new Capability.IStorage<PlayerGotNote>(){

            public NBTBase writeNBT(Capability<PlayerGotNote> capability, PlayerGotNote instance, EnumFacing side) {
                throw new UnsupportedOperationException();
            }

            public void readNBT(Capability<PlayerGotNote> capability, PlayerGotNote instance, EnumFacing side, NBTBase nbt) {
                throw new UnsupportedOperationException();
            }
        }, () -> {
            throw new UnsupportedOperationException();
        });
    }

    public void init(FMLInitializationEvent ignoredE) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)TheOneProbe.instance, (IGuiHandler)new GuiProxy());
    }

    public void postInit(FMLPostInitializationEvent ignoredE) {
        this.configureProviders();
        this.configureEntityProviders();
        if (Config.mainConfig.hasChanged()) {
            Config.mainConfig.save();
        }
    }

    private void configureProviders() {
        List<IProbeInfoProvider> providers = TheOneProbe.theOneProbeImp.getProviders();
        String[] defaultValues = new String[providers.size()];
        int i = 0;
        for (IProbeInfoProvider provider : providers) {
            defaultValues[i++] = provider.getID();
        }
        String[] sortedProviders = Config.mainConfig.getStringList("sortedProviders", Config.CATEGORY_PROVIDERS, defaultValues, "Order in which providers should be used");
        String[] excludedProviders = Config.mainConfig.getStringList("excludedProviders", Config.CATEGORY_PROVIDERS, new String[0], "Providers that should be excluded");
        HashSet<String> excluded = new HashSet<String>();
        Collections.addAll(excluded, excludedProviders);
        TheOneProbe.theOneProbeImp.configureProviders(sortedProviders, excluded);
    }

    private void configureEntityProviders() {
        List<IProbeInfoEntityProvider> providers = TheOneProbe.theOneProbeImp.getEntityProviders();
        String[] defaultValues = new String[providers.size()];
        int i = 0;
        for (IProbeInfoEntityProvider provider : providers) {
            defaultValues[i++] = provider.getID();
        }
        String[] sortedProviders = Config.mainConfig.getStringList("sortedEntityProviders", Config.CATEGORY_PROVIDERS, defaultValues, "Order in which entity providers should be used");
        String[] excludedProviders = Config.mainConfig.getStringList("excludedEntityProviders", Config.CATEGORY_PROVIDERS, new String[0], "Entity providers that should be excluded");
        HashSet<String> excluded = new HashSet<String>();
        Collections.addAll(excluded, excludedProviders);
        TheOneProbe.theOneProbeImp.configureEntityProviders(sortedProviders, excluded);
    }

    static {
        baubles = false;
        redstoneflux = false;
    }
}

