/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import mcjty.theoneprobe.ClientTools;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import org.apache.commons.lang3.text.WordUtils;

public class Tools {
    private static final Map<String, String> modNamesForIds = new HashMap<String, String>();

    private static void init() {
        Map modMap = Loader.instance().getIndexedModList();
        for (Map.Entry modEntry : modMap.entrySet()) {
            String lowercaseId = ((String)modEntry.getKey()).toLowerCase(Locale.ENGLISH);
            String modName = ((ModContainer)modEntry.getValue()).getName();
            modNamesForIds.put(lowercaseId, modName);
        }
    }

    public static String getModName(Block block) {
        ResourceLocation itemResourceLocation;
        String modId;
        String lowercaseModId;
        String modName;
        if (modNamesForIds.isEmpty()) {
            Tools.init();
        }
        if ((modName = modNamesForIds.get(lowercaseModId = (modId = Objects.requireNonNull(itemResourceLocation = block.getRegistryName()).func_110624_b()).toLowerCase(Locale.ENGLISH))) == null) {
            modName = WordUtils.capitalize((String)modId);
            modNamesForIds.put(lowercaseModId, modName);
        }
        return modName;
    }

    public static String getModName(Entity entity) {
        EntityRegistry.EntityRegistration modSpawn;
        if (modNamesForIds.isEmpty()) {
            Tools.init();
        }
        if ((modSpawn = EntityRegistry.instance().lookupModSpawn(entity.getClass(), true)) == null) {
            return "Minecraft";
        }
        ModContainer container = modSpawn.getContainer();
        if (container == null) {
            return "Minecraft";
        }
        String modId = container.getModId();
        String lowercaseModId = modId.toLowerCase(Locale.ENGLISH);
        return modNamesForIds.computeIfAbsent(lowercaseModId, key -> WordUtils.capitalize((String)modId));
    }

    public static boolean show(ProbeMode mode, IProbeConfig.ConfigMode cfg) {
        return cfg == IProbeConfig.ConfigMode.NORMAL || cfg == IProbeConfig.ConfigMode.EXTENDED && mode == ProbeMode.EXTENDED;
    }

    public static int getScreenWidth() {
        ScaledResolution resolution = new ScaledResolution(ClientTools.mc);
        return resolution.func_78326_a();
    }

    public static String capitalize(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }
}

