/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.client;

import mcjty.theoneprobe.ClientTools;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.apiimpl.client.ElementProgressRender;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import mcjty.theoneprobe.rendering.RenderHelper;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ElementProgressGradientRender
extends ElementProgressRender {
    public static void render(IProgressStyle style, long current, long max, int x, int y, int w, int h) {
        if (style.isLifeBar()) {
            ElementProgressGradientRender.renderLifeBar(current, x, y, w, h);
        } else if (style.isArmorBar()) {
            ElementProgressGradientRender.renderArmorBar(current, x, y, w, h);
        } else {
            int dx;
            RenderHelper.drawThickBeveledBox(x, y, x + w, y + h, 1, style.getBorderColor(), style.getBorderColor(), style.getBackgroundColor());
            if (current > 0L && max > 0L && (dx = (int)Math.min(current * (long)(w - 2) / max, (long)(w - 2))) > 0) {
                ElementProgressGradientRender.drawGradientBar(x + 1, y + 1, x + dx + 1, y + h - 1, style.getAlternatefilledColor(), style.getFilledColor());
            }
        }
        if (style.isShowText()) {
            RenderHelper.renderText(ClientTools.mc, x + 3, y + 2, style.getPrefix() + ElementProgress.format(current, style.getNumberFormat(), style.getSuffix()));
        }
    }

    private static void drawGradientBar(int startX, int startY, int endX, int endY, int startColor, int endColor) {
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        buffer.func_181662_b((double)startX, (double)endY, 0.0).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        buffer.func_181662_b((double)endX, (double)endY, 0.0).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        buffer.func_181662_b((double)endX, (double)startY, 0.0).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        buffer.func_181662_b((double)startX, (double)startY, 0.0).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
    }
}

