/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import java.util.Collection;
import java.util.UUID;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import mcjty.theoneprobe.config.Config;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DebugProbeInfoEntityProvider
implements IProbeInfoEntityProvider {
    @Override
    public String getID() {
        return "theoneprobe:entity.debug";
    }

    @Override
    public void addProbeEntityInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
        if (mode == ProbeMode.DEBUG && Config.showDebugInfo) {
            IProbeInfo vertical = null;
            if (entity instanceof EntityLivingBase) {
                vertical = probeInfo.vertical(new LayoutStyle().borderColor(-48060).spacing(2));
                EntityLivingBase entityLivingBase = (EntityLivingBase)entity;
                float stepHeight = entityLivingBase.field_70138_W;
                int totalArmorValue = entityLivingBase.func_70658_aO();
                int age = entityLivingBase.func_70654_ax();
                float absorptionAmount = entityLivingBase.func_110139_bj();
                float aiMoveSpeed = entityLivingBase.func_70689_ay();
                int revengeTimer = entityLivingBase.func_142015_aE();
                boolean isOnFire = entityLivingBase.func_70027_ad();
                double posX = entityLivingBase.field_70165_t;
                double posY = entityLivingBase.field_70163_u;
                double posZ = entityLivingBase.field_70161_v;
                double motionX = entityLivingBase.field_70159_w;
                double motionY = entityLivingBase.field_70181_x;
                double motionZ = entityLivingBase.field_70179_y;
                float health = entityLivingBase.func_110143_aJ();
                float maxHealth = entityLivingBase.func_110138_aP();
                Collection activeEffects = entityLivingBase.func_70651_bq();
                UUID uuid = entityLivingBase.func_110124_au();
                String entityName = entityLivingBase.func_95999_t();
                vertical.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.step_height_indicator*} " + (Object)((Object)TextStyleClass.INFO) + stepHeight).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.total_armor_indicator*} " + (Object)((Object)TextStyleClass.INFO) + totalArmorValue).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.age_indicator*} " + (Object)((Object)TextStyleClass.INFO) + age).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.absorption_indicator*} " + (Object)((Object)TextStyleClass.INFO) + absorptionAmount).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.ai_move_speed_indicator*} " + (Object)((Object)TextStyleClass.INFO) + aiMoveSpeed).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.revenge_timer_indicator*} " + (Object)((Object)TextStyleClass.INFO) + revengeTimer).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.on_fire_indicator*} " + (Object)((Object)TextStyleClass.INFO) + isOnFire).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.position_indicator*} " + (Object)((Object)TextStyleClass.INFO) + String.format("X: %.2f, Y: %.2f, Z: %.2f", posX, posY, posZ)).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.motion_indicator*} " + (Object)((Object)TextStyleClass.INFO) + String.format("X: %.2f, Y: %.2f, Z: %.2f", motionX, motionY, motionZ)).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.probe.health_indicator*} " + (Object)((Object)TextStyleClass.INFO) + health + " / " + maxHealth);
                if (Config.showDebugUUID) {
                    vertical.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.uuid_indicator*} " + (Object)((Object)TextStyleClass.INFO) + uuid);
                }
                if (entityLivingBase.func_145818_k_()) {
                    vertical.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.custom_name_indicator*} " + (Object)((Object)TextStyleClass.INFO) + entityName);
                }
                if (!activeEffects.isEmpty()) {
                    vertical.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.active_effects_indicator*} ");
                    for (PotionEffect effect : activeEffects) {
                        vertical.text((Object)((Object)TextStyleClass.INFO) + effect.func_76453_d() + " (" + effect.func_76458_c() + ") - " + effect.func_76459_b() + " ticks");
                    }
                }
            }
            if (entity instanceof EntityLiving) {
                EntityLiving entityLiving = (EntityLiving)entity;
                boolean isLeftHanded = entityLiving.func_184638_cS();
                int maxFallHeight = entityLiving.func_82143_as();
                int maxInChunk = entityLiving.func_70641_bl();
                vertical.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.is_left_handed_indicator*} " + (Object)((Object)TextStyleClass.INFO) + isLeftHanded).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.max_fall_height_indicator*} " + (Object)((Object)TextStyleClass.INFO) + maxFallHeight).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.max_spawnable_in_chunk_indicator*} " + (Object)((Object)TextStyleClass.INFO) + maxInChunk);
            }
            if (entity instanceof EntityAgeable) {
                EntityAgeable entityAgeable = (EntityAgeable)entity;
                int growingAge = entityAgeable.func_70874_b();
                vertical.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.growing_age_indicator*} " + (Object)((Object)TextStyleClass.INFO) + growingAge);
            }
            if (entity instanceof EntityWaterMob) {
                EntityWaterMob entityWaterMob = (EntityWaterMob)entity;
                boolean canBreatheUnderwater = entityWaterMob.func_70648_aU();
                vertical.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.can_breathe_underwater_indicator*} " + (Object)((Object)TextStyleClass.INFO) + canBreatheUnderwater).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.in_water_indicator*} " + (Object)((Object)TextStyleClass.INFO) + entityWaterMob.func_70090_H());
            }
            if (entity instanceof EntityChicken) {
                EntityChicken entityChicken = (EntityChicken)entity;
                vertical.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.next_egg_in_indicator*} " + (Object)((Object)TextStyleClass.INFO) + entityChicken.field_70887_j);
            }
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityPlayer = (EntityPlayer)entity;
                int foodLevel = entityPlayer.func_71024_bL().func_75116_a();
                float saturationLevel = entityPlayer.func_71024_bL().func_75115_e();
                float luck = entityPlayer.func_184817_da();
                BlockPos bedLocation = entityPlayer.func_180470_cg();
                vertical.text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.food_level_indicator*} " + (Object)((Object)TextStyleClass.INFO) + foodLevel).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.saturation_level_indicator*} " + (Object)((Object)TextStyleClass.INFO) + saturationLevel).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.luck_indicator*} " + (Object)((Object)TextStyleClass.INFO) + luck).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.debug_probe.bed_location_indicator*} " + (Object)((Object)TextStyleClass.INFO) + bedLocation);
            }
        }
    }
}

