/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import lombok.NonNull;
import mcjty.theoneprobe.Utilities;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityEnchantmentTable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class EnchantingPowerInfoProvider
implements IProbeInfoProvider {
    @Override
    public String getID() {
        return Utilities.getProviderId("enchanting_power");
    }

    @Override
    public void addProbeInfo(ProbeMode mode, @NonNull IProbeInfo probeInfo, EntityPlayer player, @NonNull World world, @NonNull IBlockState blockState, @NonNull IProbeHitData data) {
        if (probeInfo == null) {
            throw new NullPointerException("probeInfo is marked non-null but is null");
        }
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        if (blockState == null) {
            throw new NullPointerException("blockState is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (!blockState.func_177230_c().hasTileEntity(blockState) || !(world.func_175625_s(data.getPos()) instanceof TileEntityEnchantmentTable)) {
            return;
        }
        float enchantingPower = 0.0f;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0 || !world.func_175623_d((BlockPos)pos.func_189533_g((Vec3i)data.getPos().func_177982_a(z, 0, x))) || !world.func_175623_d((BlockPos)pos.func_189533_g((Vec3i)data.getPos().func_177982_a(z, 1, x)))) continue;
                enchantingPower += ForgeHooks.getEnchantPower((World)world, (BlockPos)pos.func_189533_g((Vec3i)data.getPos().func_177982_a(z * 2, 0, x * 2)));
                enchantingPower += ForgeHooks.getEnchantPower((World)world, (BlockPos)pos.func_189533_g((Vec3i)data.getPos().func_177982_a(z * 2, 1, x * 2)));
                if (x == 0 || z == 0) continue;
                enchantingPower += ForgeHooks.getEnchantPower((World)world, (BlockPos)pos.func_189533_g((Vec3i)data.getPos().func_177982_a(z * 2, 0, x)));
                enchantingPower += ForgeHooks.getEnchantPower((World)world, (BlockPos)pos.func_189533_g((Vec3i)data.getPos().func_177982_a(z * 2, 1, x)));
                enchantingPower += ForgeHooks.getEnchantPower((World)world, (BlockPos)pos.func_189533_g((Vec3i)data.getPos().func_177982_a(z, 0, x * 2)));
                enchantingPower += ForgeHooks.getEnchantPower((World)world, (BlockPos)pos.func_189533_g((Vec3i)data.getPos().func_177982_a(z, 1, x * 2)));
            }
        }
        if (enchantingPower > 0.0f) {
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(new ItemStack(Items.field_151134_bR), probeInfo.defaultItemStyle().width(16).height(16)).text((Object)((Object)TextStyleClass.LABEL) + "{*theoneprobe.probe.enchanting_power_indicator*} " + TextFormatting.LIGHT_PURPLE + Utilities.FORMAT.format(enchantingPower));
        }
    }
}

