/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IIconStyle;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.items.ModItems;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class HarvestInfoTools {
    private static final ResourceLocation ICONS = new ResourceLocation("theoneprobe", "textures/gui/icons.png");
    private static final HashMap<String, ItemStack> testTools = new HashMap();

    static void showHarvestInfo(IProbeInfo probeInfo, World world, BlockPos pos, Block block, IBlockState blockState, EntityPlayer player) {
        if (ModItems.isProbe(player.func_184614_ca())) {
            return;
        }
        boolean harvestable = HarvestInfoTools.canBlockBeHarvested(block, world, pos, player);
        String harvestTool = HarvestInfoTools.getHarvestTool(block, blockState, world, pos);
        String harvestLevelName = HarvestInfoTools.getHarvestLevelName(block, blockState);
        boolean harvestStyleVanilla = Config.getHarvestStyleVanilla();
        int offs = harvestStyleVanilla ? 16 : 0;
        int dim = harvestStyleVanilla ? 13 : 16;
        ILayoutStyle alignment = probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER);
        IIconStyle iconStyle = probeInfo.defaultIconStyle().width(harvestStyleVanilla ? 18 : 20).height(harvestStyleVanilla ? 14 : 16).textureWidth(32).textureHeight(32);
        IProbeInfo horizontal = probeInfo.horizontal(alignment);
        if (harvestable) {
            horizontal.icon(ICONS, 0, offs, dim, dim, iconStyle).text((Object)((Object)TextStyleClass.OK) + HarvestInfoTools.formatToolInfo(harvestTool));
        } else {
            String text = (Object)((Object)TextStyleClass.WARNING) + HarvestInfoTools.formatToolInfo(harvestTool);
            text = harvestLevelName != null ? text + " ({*theoneprobe.probe.level_indicator*} {*" + harvestLevelName + "*}" + ")" : text + "";
            horizontal.icon(ICONS, 16, offs, dim, dim, iconStyle).text(text);
        }
    }

    private static boolean canBlockBeHarvested(Block block, World world, BlockPos pos, EntityPlayer player) {
        return block.canHarvestBlock((IBlockAccess)world, pos, player) && world.func_180495_p(pos).func_185887_b(world, pos) >= 0.0f;
    }

    private static String getHarvestTool(Block block, IBlockState blockState, World world, BlockPos pos) {
        float hardness;
        String tool = HarvestInfoTools.convertToTranslation(block, blockState);
        if (tool == null && (hardness = blockState.func_185887_b(world, pos)) > 0.0f) {
            for (Map.Entry<String, ItemStack> entry : testTools.entrySet()) {
                ItemStack testTool = entry.getValue();
                if (testTool == null || !(testTool.func_77973_b() instanceof ItemTool)) continue;
                ItemTool toolItem = (ItemTool)testTool.func_77973_b();
                if (!(testTool.func_150997_a(blockState) >= toolItem.field_77862_b.func_77998_b())) continue;
                return entry.getKey();
            }
        }
        return tool;
    }

    private static String getHarvestLevelName(Block block, IBlockState blockState) {
        int harvestLevel = block.getHarvestLevel(blockState);
        if (harvestLevel < 0) {
            return null;
        }
        if (harvestLevel >= Config.getHarvestLevels().length) {
            return Config.getHarvestLevels()[Config.getHarvestLevels().length - 1];
        }
        return Config.getHarvestLevels()[harvestLevel];
    }

    private static String formatToolInfo(String harvestTool) {
        if (harvestTool != null) {
            return "{*" + harvestTool + "*}";
        }
        return "{*theoneprobe.probe.notool_indicator*}";
    }

    private static String convertToTranslation(Block block, IBlockState blockState) {
        String harvestTool = block.getHarvestTool(blockState);
        try {
            switch (Objects.requireNonNull(harvestTool)) {
                case "pickaxe": {
                    return "theoneprobe.probe.pickaxe";
                }
                case "shovel": {
                    return "theoneprobe.probe.shovel";
                }
                case "axe": {
                    return "theoneprobe.probe.axe";
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    static void showHarvestLevel(IProbeInfo probeInfo, IBlockState blockState, Block block) {
        String harvestTool = HarvestInfoTools.convertToTranslation(block, blockState);
        if (harvestTool != null) {
            String harvestLevelName = HarvestInfoTools.getHarvestLevelName(block, blockState);
            if (harvestLevelName != null) {
                probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "{*" + "theoneprobe.probe.tool_indicator" + "*}" + " " + (Object)((Object)TextStyleClass.INFO) + "{*" + harvestTool + "*}" + " (" + "{*" + "theoneprobe.probe.level_indicator" + "*}" + " " + "{*" + harvestLevelName + "*}" + ")");
            } else {
                probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "{*" + "theoneprobe.probe.tool_indicator" + "*}" + " " + (Object)((Object)TextStyleClass.INFO) + "{*" + harvestTool + "*}");
            }
        }
    }

    static void showCanBeHarvested(IProbeInfo probeInfo, World world, BlockPos pos, Block block, EntityPlayer player) {
        if (ModItems.isProbe(player.func_184614_ca())) {
            return;
        }
        if (HarvestInfoTools.canBlockBeHarvested(block, world, pos, player)) {
            probeInfo.text((Object)((Object)TextStyleClass.OK) + "{*" + "theoneprobe.probe.harvestable_indicator" + "*}");
        } else {
            probeInfo.text((Object)((Object)TextStyleClass.WARNING) + "{*" + "theoneprobe.probe.not_harvestable_indicator" + "*}");
        }
    }

    static {
        testTools.put("theoneprobe.probe.shovel", new ItemStack(Items.field_151038_n));
        testTools.put("theoneprobe.probe.axe", new ItemStack(Items.field_151053_p));
        testTools.put("theoneprobe.probe.pickaxe", new ItemStack(Items.field_151039_o));
    }
}

