/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.gui.Preset;
import org.apache.commons.lang3.tuple.Pair;

public class PresetBuilder {
    private static final List<Preset> presets = new ArrayList<Preset>();
    private String name;
    private int boxBorderColor = 0xFFFFFF;
    private int boxFillColor = 0;
    private int boxThickness = 1;
    private int boxOffset = 0;
    private final Map<TextStyleClass, String> textStyleClasses = new HashMap<TextStyleClass, String>();

    public PresetBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public PresetBuilder setBoxBorderColor(int color) {
        this.boxBorderColor = color;
        return this;
    }

    public PresetBuilder setBoxFillColor(int color) {
        this.boxFillColor = color;
        return this;
    }

    public PresetBuilder setBoxThickness(int thickness) {
        this.boxThickness = thickness;
        return this;
    }

    public PresetBuilder setBoxOffset(int offset) {
        this.boxOffset = offset;
        return this;
    }

    public PresetBuilder addTextStyleClass(TextStyleClass styleClass, String styleName) {
        this.textStyleClasses.put(styleClass, styleName);
        return this;
    }

    public Preset build() {
        Preset preset = new Preset(this.name, this.boxBorderColor, this.boxFillColor, this.boxThickness, this.boxOffset, (Pair[])this.textStyleClasses.entrySet().stream().map(entry -> Pair.of(entry.getKey(), entry.getValue())).toArray(Pair[]::new));
        presets.add(preset);
        return preset;
    }

    public static void applyPreset(Preset preset) {
        if (preset == null) {
            throw new IllegalArgumentException("Preset cannot be null.");
        }
        for (Map.Entry<TextStyleClass, String> entry : Config.defaultTextStyleClasses.entrySet()) {
            Config.setTextStyle(entry.getKey(), entry.getValue());
        }
        Config.setBoxStyle(preset.getBoxThickness(), preset.getBoxBorderColor(), preset.getBoxFillColor());
        for (Map.Entry<TextStyleClass, String> entry : preset.getTextStyleClasses().entrySet()) {
            Config.setTextStyle(entry.getKey(), entry.getValue());
        }
    }

    public String getName() {
        return this.name;
    }

    public int getBoxBorderColor() {
        return this.boxBorderColor;
    }

    public int getBoxFillColor() {
        return this.boxFillColor;
    }

    public int getBoxThickness() {
        return this.boxThickness;
    }

    public int getBoxOffset() {
        return this.boxOffset;
    }

    public Map<TextStyleClass, String> getTextStyleClasses() {
        return new HashMap<TextStyleClass, String>(this.textStyleClasses);
    }

    public static List<Preset> getPresets() {
        return presets;
    }

    public static void removeAll() {
        presets.clear();
    }

    public static boolean removePresetByName(String name) {
        return presets.removeIf(preset -> preset.getName().equals(name));
    }

    public static void addDefaultPresets() {
        presets.add(new Preset("Default", -6710887, 1426089625, 2, 0, new Pair[0]));
        presets.add(new Preset("WAILA", -12254256, -16777216, 1, 1, new Pair[0]));
        presets.add(new Preset("Jade", -13487311, -14670310, 1, 1, new Pair[0]));
        presets.add(new Preset("Fully transparent", 0, 0, 0, 0, new Pair[0]));
        presets.add(new Preset("Black & White", -1, -16777216, 2, 0, Pair.of((Object)((Object)TextStyleClass.MODNAME), (Object)"white,italic"), Pair.of((Object)((Object)TextStyleClass.NAME), (Object)"white,bold"), Pair.of((Object)((Object)TextStyleClass.INFO), (Object)"white"), Pair.of((Object)((Object)TextStyleClass.INFOIMP), (Object)"white,bold"), Pair.of((Object)((Object)TextStyleClass.WARNING), (Object)"white"), Pair.of((Object)((Object)TextStyleClass.ERROR), (Object)"white,underline"), Pair.of((Object)((Object)TextStyleClass.OBSOLETE), (Object)"white,strikethrough"), Pair.of((Object)((Object)TextStyleClass.LABEL), (Object)"white,bold"), Pair.of((Object)((Object)TextStyleClass.OK), (Object)"white"), Pair.of((Object)((Object)TextStyleClass.PROGRESS), (Object)"white")));
        presets.add(new Preset("Crazy!", -16711936, 0x55FF0000, 2, 0, Pair.of((Object)((Object)TextStyleClass.MODNAME), (Object)"green"), Pair.of((Object)((Object)TextStyleClass.NAME), (Object)"yellow,bold"), Pair.of((Object)((Object)TextStyleClass.INFO), (Object)"cyan,bold"), Pair.of((Object)((Object)TextStyleClass.INFOIMP), (Object)"magenta,bold"), Pair.of((Object)((Object)TextStyleClass.WARNING), (Object)"orange,bold"), Pair.of((Object)((Object)TextStyleClass.ERROR), (Object)"red,bold"), Pair.of((Object)((Object)TextStyleClass.OBSOLETE), (Object)"gray,bold"), Pair.of((Object)((Object)TextStyleClass.LABEL), (Object)"blue,bold"), Pair.of((Object)((Object)TextStyleClass.OK), (Object)"green,bold"), Pair.of((Object)((Object)TextStyleClass.PROGRESS), (Object)"white,bold")));
        presets.add(new Preset("Soft Pastels", -2049025, 1438384096, 1, 1, Pair.of((Object)((Object)TextStyleClass.MODNAME), (Object)"light_purple,italic")));
        presets.add(new Preset("Ocean Blue", -16764058, 1432787404, 2, 0, Pair.of((Object)((Object)TextStyleClass.MODNAME), (Object)"cyan"), Pair.of((Object)((Object)TextStyleClass.NAME), (Object)"light_blue,bold"), Pair.of((Object)((Object)TextStyleClass.INFO), (Object)"white"), Pair.of((Object)((Object)TextStyleClass.INFOIMP), (Object)"white,bold"), Pair.of((Object)((Object)TextStyleClass.WARNING), (Object)"yellow,bold"), Pair.of((Object)((Object)TextStyleClass.ERROR), (Object)"red,bold"), Pair.of((Object)((Object)TextStyleClass.OBSOLETE), (Object)"gray,bold,italic"), Pair.of((Object)((Object)TextStyleClass.LABEL), (Object)"aqua,bold"), Pair.of((Object)((Object)TextStyleClass.OK), (Object)"green,bold"), Pair.of((Object)((Object)TextStyleClass.PROGRESS), (Object)"white,bold")));
    }
}

