/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.compat.BaubleTools;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.items.CreativeProbe;
import mcjty.theoneprobe.items.Probe;
import mcjty.theoneprobe.items.ProbeNote;
import mcjty.theoneprobe.probe.ProbeArmor;
import mcjty.theoneprobe.setup.ModSetup;
import mcjty.theoneprobe.setup.Registration;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModItems {
    public static CreativeProbe creativeProbe;
    public static Probe probe;
    public static Item probeGoggles;
    public static ProbeNote probeNote;
    private static final List<Item> helmetModels;
    public static final String PROBETAG = "theoneprobe";
    public static CreativeTabs tabProbe;

    public static void init() {
        if (Config.regProbes) {
            tabProbe = new CreativeTabs("Probe"){

                public ItemStack func_78016_d() {
                    return new ItemStack((Item)probe);
                }
            };
            int stepCount = ModSetup.baubles ? 5 : 4;
            ProgressManager.ProgressBar bar = ProgressManager.push((String)"Loading Mod Items", (int)stepCount);
            bar.step("Initializing Probe");
            probe = new Probe();
            bar.step("Initializing Creative Probe");
            creativeProbe = new CreativeProbe();
            bar.step("Creating Armor Probes");
            if (Config.regProbeHelmets) {
                int totalItems = ForgeRegistries.ITEMS.getValuesCollection().size();
                ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Processing Helmets", (int)totalItems);
                for (Item item : ForgeRegistries.ITEMS.getValuesCollection()) {
                    progressBar.step(item.getRegistryName() != null ? item.getRegistryName().toString() : "Unknown Item");
                    if (!(item instanceof ItemArmor) || ((ItemArmor)item).field_77881_a != EntityEquipmentSlot.HEAD) continue;
                    ResourceLocation registryName = item.getRegistryName();
                    if (registryName != null && !Config.probeHelmetBlacklist.contains(registryName.func_110624_b())) {
                        if (((ItemArmor)item).func_82812_d().equals((Object)ItemArmor.ArmorMaterial.LEATHER)) continue;
                        String probeHelmetName = registryName.func_110623_a() + "_probe";
                        Item madeHelmet = ModItems.makeHelmet(item, probeHelmetName);
                        TheOneProbe.setup.getLogger().info("Made Helmet: {}", (Object)madeHelmet.getRegistryName());
                        continue;
                    }
                    TheOneProbe.setup.getLogger().debug("Not making helmet from: {}, matches: {}", (Object)registryName, (Object)registryName.func_110624_b());
                }
                ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
            }
            bar.step("Initializing Probe Note");
            probeNote = new ProbeNote();
            if (ModSetup.baubles) {
                bar.step("Initializing Probe Goggles");
                probeGoggles = BaubleTools.initProbeGoggle();
            }
            ProgressManager.pop((ProgressManager.ProgressBar)bar);
        }
    }

    public static Item makeHelmet(Item baseItem, String name) {
        ItemArmor.ArmorMaterial material = ((ItemArmor)baseItem).func_82812_d();
        int renderIndex = ((ItemArmor)baseItem).field_77880_c;
        ProbeArmor item = new ProbeArmor(material, renderIndex, EntityEquipmentSlot.HEAD, ModItems.getBaseTexture(baseItem)){

            public boolean func_77614_k() {
                return true;
            }
        };
        item.func_77655_b("theoneprobe." + name);
        item.setRegistryName(name);
        item.func_77637_a(tabProbe);
        Registration.addItem((Item)item);
        helmetModels.add((Item)item);
        GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation(PROBETAG, name + "_recipe"), null, (ItemStack)new ItemStack((Item)item), (Ingredient[])new Ingredient[]{Ingredient.func_193368_a((Item[])new Item[]{baseItem}), Ingredient.func_193368_a((Item[])new Item[]{probe})});
        return item;
    }

    private static String getBaseTexture(Item baseItem) {
        String registryNamespace = baseItem.getRegistryName().func_110624_b();
        String registryPath = baseItem.getRegistryName().func_110623_a();
        String[] parts = registryPath.split("_");
        if (Objects.equals(parts[0], "golden") & registryNamespace.equals("minecraft")) {
            parts[0] = "gold";
        }
        String armorMaterial = parts[0];
        return registryNamespace + ":textures/models/armor/" + armorMaterial + "_layer_1.png";
    }

    @SideOnly(value=Side.CLIENT)
    public static void initClient() {
        if (Config.regProbes) {
            ModItems.initModel(probe);
            ModItems.initModel(creativeProbe);
            ModItems.initModel(probeNote);
            for (Item helmet : helmetModels) {
                ModItems.initModel(helmet);
            }
            if (ModSetup.baubles) {
                ModItems.initModel(probeGoggles);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void initModel(Item helmet) {
        ModelLoader.setCustomModelResourceLocation((Item)helmet, (int)0, (ModelResourceLocation)new ModelResourceLocation(helmet.getRegistryName(), "inventory"));
    }

    @Deprecated
    public static boolean isProbeInHand(ItemStack stack) {
        return ModItems.isProbe(stack);
    }

    public static boolean isProbe(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b() == probe || stack.func_77973_b() == creativeProbe) {
            return true;
        }
        if (stack.func_77978_p() == null) {
            return false;
        }
        return stack.func_77978_p().func_74764_b(PROBETAG);
    }

    private static boolean isProbeHelmet(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77978_p() == null) {
            return false;
        }
        return stack.func_77978_p().func_74764_b(PROBETAG);
    }

    public static boolean hasAProbeSomewhere(EntityPlayer player) {
        return ModItems.isProbe(player.func_184586_b(EnumHand.MAIN_HAND)) || ModItems.isProbe(player.func_184586_b(EnumHand.OFF_HAND)) || ModItems.isProbeHelmet(player.field_71071_by.func_70301_a(39)) || ModSetup.baubles && BaubleTools.hasProbeGoggle(player);
    }

    static {
        helmetModels = new ArrayList<Item>();
    }
}

