/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.rendering;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import mcjty.theoneprobe.ClientTools;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IOverlayStyle;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.ProbeHitData;
import mcjty.theoneprobe.apiimpl.ProbeHitEntityData;
import mcjty.theoneprobe.apiimpl.ProbeInfo;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import mcjty.theoneprobe.apiimpl.elements.ElementText;
import mcjty.theoneprobe.apiimpl.providers.DefaultProbeInfoEntityProvider;
import mcjty.theoneprobe.apiimpl.providers.DefaultProbeInfoProvider;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.network.PacketGetEntityInfo;
import mcjty.theoneprobe.network.PacketGetInfo;
import mcjty.theoneprobe.network.PacketHandler;
import mcjty.theoneprobe.network.ThrowableIdentity;
import mcjty.theoneprobe.rendering.RenderHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;

public class OverlayRenderer {
    private static Map<Pair<Integer, BlockPos>, Pair<Long, ProbeInfo>> cachedInfo = new HashMap<Pair<Integer, BlockPos>, Pair<Long, ProbeInfo>>();
    private static Map<UUID, Pair<Long, ProbeInfo>> cachedEntityInfo = new HashMap<UUID, Pair<Long, ProbeInfo>>();
    private static long lastCleanupTime = 0L;
    private static Pair<Long, ProbeInfo> lastPair;
    private static long lastPairTime;
    private static long lastRenderedTime;

    public static void registerProbeInfo(int dim, BlockPos pos, ProbeInfo probeInfo) {
        if (probeInfo == null) {
            return;
        }
        long time = System.currentTimeMillis();
        cachedInfo.put((Pair<Integer, BlockPos>)Pair.of((Object)dim, (Object)pos), (Pair<Long, ProbeInfo>)Pair.of((Object)time, (Object)probeInfo));
    }

    public static void registerProbeInfo(UUID uuid, ProbeInfo probeInfo) {
        if (probeInfo == null) {
            return;
        }
        long time = System.currentTimeMillis();
        cachedEntityInfo.put(uuid, (Pair<Long, ProbeInfo>)Pair.of((Object)time, (Object)probeInfo));
    }

    public static void renderHUD(ProbeMode mode, float partialTicks) {
        if (!ClientTools.mc.field_71474_y.field_74330_P) {
            float dist = Config.probeDistance;
            RayTraceResult mouseOver = ClientTools.mc.field_71476_x;
            if (mouseOver != null && mouseOver.field_72313_a == RayTraceResult.Type.ENTITY) {
                GlStateManager.func_179094_E();
                double scale = Config.tooltipScale;
                ScaledResolution scaledresolution = new ScaledResolution(ClientTools.mc);
                double sw = scaledresolution.func_78327_c();
                double sh = scaledresolution.func_78324_d();
                OverlayRenderer.setupOverlayRendering(sw * scale, sh * scale);
                OverlayRenderer.renderHUDEntity(mode, mouseOver, sw * scale, sh * scale);
                OverlayRenderer.setupOverlayRendering(sw, sh);
                GlStateManager.func_179121_F();
                OverlayRenderer.checkCleanup();
                return;
            }
            EntityPlayerSP entity = ClientTools.mc.field_71439_g;
            Vec3d start = entity.func_174824_e(partialTicks);
            Vec3d vec31 = entity.func_70676_i(partialTicks);
            Vec3d end = start.func_72441_c(vec31.field_72450_a * (double)dist, vec31.field_72448_b * (double)dist, vec31.field_72449_c * (double)dist);
            mouseOver = entity.func_130014_f_().func_72901_a(start, end, Config.showLiquids);
            if (mouseOver == null) {
                return;
            }
            if (mouseOver.field_72313_a == RayTraceResult.Type.BLOCK) {
                GlStateManager.func_179094_E();
                double scale = Config.tooltipScale;
                ScaledResolution scaledresolution = new ScaledResolution(ClientTools.mc);
                double sw = scaledresolution.func_78327_c();
                double sh = scaledresolution.func_78324_d();
                OverlayRenderer.setupOverlayRendering(sw * scale, sh * scale);
                OverlayRenderer.renderHUDBlock(mode, mouseOver, sw * scale, sh * scale);
                OverlayRenderer.setupOverlayRendering(sw, sh);
                GlStateManager.func_179121_F();
            }
            OverlayRenderer.checkCleanup();
        }
    }

    public static void setupOverlayRendering(double sw, double sh) {
        GlStateManager.func_179086_m((int)256);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)sw, (double)sh, (double)0.0, (double)1000.0, (double)3000.0);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179096_D();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    private static void checkCleanup() {
        long time = System.currentTimeMillis();
        if (time > lastCleanupTime + 5000L) {
            OverlayRenderer.cleanupCachedBlocks(time);
            OverlayRenderer.cleanupCachedEntities(time);
            lastCleanupTime = time;
        }
    }

    private static void requestEntityInfo(ProbeMode mode, RayTraceResult mouseOver, Entity entity, EntityPlayerSP player) {
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketGetEntityInfo(player.func_130014_f_().field_73011_w.getDimension(), mode, mouseOver, entity));
    }

    private static boolean handleCacheAndRender(Pair cacheEntry, long time, double sw, double sh, IElement extraElement, UUID entityUUID, BlockPos blockPos, ProbeMode mode, RayTraceResult mouseOver, EntityPlayerSP player, int dimension) {
        if (cacheEntry == null || cacheEntry.getValue() == null) {
            if (cacheEntry == null || time >= (Long)cacheEntry.getLeft()) {
                if (entityUUID != null) {
                    cachedEntityInfo.put(entityUUID, (Pair<Long, ProbeInfo>)Pair.of((Object)(time + 500L), null));
                    OverlayRenderer.requestEntityInfo(mode, mouseOver, mouseOver.field_72308_g, player);
                } else if (blockPos != null) {
                    cachedInfo.put((Pair<Integer, BlockPos>)Pair.of((Object)dimension, (Object)blockPos), (Pair<Long, ProbeInfo>)Pair.of((Object)(time + 500L), null));
                    OverlayRenderer.requestBlockInfo(mode, mouseOver, blockPos, player);
                }
            }
            if (lastPair != null && time < lastPairTime + (long)Config.timeout) {
                OverlayRenderer.renderElements((ProbeInfo)lastPair.getRight(), Config.getDefaultOverlayStyle(), sw, sh, extraElement);
                lastRenderedTime = time;
            } else if (Config.waitingForServerTimeout > 0 && lastRenderedTime != -1L && time > lastRenderedTime + (long)Config.waitingForServerTimeout) {
                ProbeInfo info;
                if (entityUUID != null) {
                    info = OverlayRenderer.getWaitingEntityInfo(mode, mouseOver, mouseOver.field_72308_g, player);
                    OverlayRenderer.registerProbeInfo(entityUUID, info);
                } else {
                    info = OverlayRenderer.getWaitingInfo(mode, mouseOver, blockPos, player);
                    OverlayRenderer.registerProbeInfo(dimension, blockPos, info);
                }
                lastPair = Pair.of((Object)time, (Object)info);
                lastPairTime = time;
                OverlayRenderer.renderElements(info, Config.getDefaultOverlayStyle(), sw, sh, extraElement);
                lastRenderedTime = time;
            }
            return false;
        }
        if (time > (Long)cacheEntry.getLeft() + (long)Config.timeout) {
            if (entityUUID != null) {
                cachedInfo.put((Pair<Integer, BlockPos>)Pair.of((Object)dimension, (Object)blockPos), (Pair<Long, ProbeInfo>)Pair.of((Object)(time + 500L), (Object)((ProbeInfo)cacheEntry.getRight())));
                OverlayRenderer.requestEntityInfo(mode, mouseOver, mouseOver.field_72308_g, player);
            } else {
                cachedInfo.put((Pair<Integer, BlockPos>)Pair.of((Object)dimension, (Object)blockPos), (Pair<Long, ProbeInfo>)Pair.of((Object)(time + 500L), (Object)((ProbeInfo)cacheEntry.getRight())));
                OverlayRenderer.requestBlockInfo(mode, mouseOver, blockPos, player);
            }
        }
        OverlayRenderer.renderElements((ProbeInfo)cacheEntry.getRight(), Config.getDefaultOverlayStyle(), sw, sh, extraElement);
        lastRenderedTime = time;
        lastPair = cacheEntry;
        lastPairTime = time;
        return true;
    }

    private static void renderHUDEntity(ProbeMode mode, RayTraceResult mouseOver, double sw, double sh) {
        Entity entity = mouseOver.field_72308_g;
        if (entity == null) {
            return;
        }
        if (entity instanceof MultiPartEntityPart) {
            MultiPartEntityPart part = (MultiPartEntityPart)entity;
            if (part.field_70259_a instanceof Entity) {
                entity = (Entity)part.field_70259_a;
            }
        }
        UUID uuid = entity.getPersistentID();
        EntityPlayerSP player = ClientTools.mc.field_71439_g;
        long time = System.currentTimeMillis();
        Pair<Long, ProbeInfo> cacheEntry = cachedEntityInfo.get(uuid);
        OverlayRenderer.handleCacheAndRender(cacheEntry, time, sw, sh, null, uuid, null, mode, mouseOver, player, -1);
    }

    private static void renderHUDBlock(ProbeMode mode, RayTraceResult mouseOver, double sw, double sh) {
        float damage;
        BlockPos blockPos = mouseOver.func_178782_a();
        if (blockPos == null) {
            return;
        }
        EntityPlayerSP player = ClientTools.mc.field_71439_g;
        if (player.func_130014_f_().func_175623_d(blockPos)) {
            return;
        }
        long time = System.currentTimeMillis();
        IElement damageElement = null;
        if (Config.showBreakProgress > 0 && (damage = ClientTools.mc.field_71442_b.field_78770_f) > 0.0f) {
            damageElement = Config.showBreakProgress == 2 ? new ElementText(TextFormatting.RED + I18n.func_135052_a((String)"theoneprobe.probe.progress_indicator", (Object[])new Object[0]) + " " + (int)(damage * 100.0f) + "%") : new ElementProgress((long)(damage * 100.0f), 100L, new ProgressStyle().prefix(I18n.func_135052_a((String)"theoneprobe.probe.progress_indicator", (Object[])new Object[0]) + " ").suffix("%").width(85).showText(Config.showBreakProgressText).backgroundColor(Config.probeProgressBackgroundColor).borderColor(Config.probeProgressBorderColor).filledColor(Config.probeProgressColor).alternateFilledColor(Config.probeProgressAltColor));
        }
        int dimension = player.func_130014_f_().field_73011_w.getDimension();
        Pair key = Pair.of((Object)dimension, (Object)blockPos);
        Pair<Long, ProbeInfo> cacheEntry = cachedInfo.get(key);
        OverlayRenderer.handleCacheAndRender(cacheEntry, time, sw, sh, damageElement, null, blockPos, mode, mouseOver, player, dimension);
    }

    private static ProbeInfo getWaitingInfo(ProbeMode mode, RayTraceResult mouseOver, BlockPos blockPos, EntityPlayerSP player) {
        ProbeInfo probeInfo = TheOneProbe.theOneProbeImp.create();
        World world = player.func_130014_f_();
        IBlockState blockState = world.func_180495_p(blockPos);
        Block block = blockState.func_177230_c();
        ItemStack pickBlock = block.getPickBlock(blockState, mouseOver, world, blockPos, (EntityPlayer)player);
        ProbeHitData data = new ProbeHitData(blockPos, mouseOver.field_72307_f, mouseOver.field_178784_b, pickBlock);
        IProbeConfig probeConfig = TheOneProbe.theOneProbeImp.createProbeConfig();
        try {
            DefaultProbeInfoProvider.showStandardBlockInfo(probeConfig, mode, probeInfo, blockState, block, data, world);
        }
        catch (Exception e) {
            ThrowableIdentity.registerThrowable(e);
            probeInfo.text((Object)((Object)TextStyleClass.ERROR) + "{*theoneprobe.probe.error_log_indicator*}");
        }
        probeInfo.text((Object)((Object)TextStyleClass.ERROR) + "{*theoneprobe.probe.waiting_server_indicator*}");
        return probeInfo;
    }

    private static ProbeInfo getWaitingEntityInfo(ProbeMode mode, RayTraceResult mouseOver, Entity entity, EntityPlayerSP player) {
        ProbeInfo probeInfo = TheOneProbe.theOneProbeImp.create();
        ProbeHitEntityData data = new ProbeHitEntityData(mouseOver.field_72307_f);
        IProbeConfig probeConfig = TheOneProbe.theOneProbeImp.createProbeConfig();
        try {
            DefaultProbeInfoEntityProvider.showStandardInfo(mode, probeInfo, entity, probeConfig);
        }
        catch (Exception e) {
            ThrowableIdentity.registerThrowable(e);
            probeInfo.text((Object)((Object)TextStyleClass.ERROR) + "{*theoneprobe.probe.error_log_indicator*}");
        }
        probeInfo.text((Object)((Object)TextStyleClass.ERROR) + "{*theoneprobe.probe.waiting_server_indicator*}");
        return probeInfo;
    }

    private static void requestBlockInfo(ProbeMode mode, RayTraceResult mouseOver, BlockPos blockPos, EntityPlayerSP player) {
        World world = player.func_130014_f_();
        IBlockState blockState = world.func_180495_p(blockPos);
        Block block = blockState.func_177230_c();
        ItemStack pickBlock = block.getPickBlock(blockState, mouseOver, world, blockPos, (EntityPlayer)player);
        if (pickBlock == null || !pickBlock.func_190926_b() && pickBlock.func_77973_b() == null) {
            pickBlock = ItemStack.field_190927_a;
        }
        if (!pickBlock.func_190926_b() && Config.getDontSendNBTSet().contains(pickBlock.func_77973_b().getRegistryName())) {
            pickBlock = pickBlock.func_77946_l();
            pickBlock.func_77982_d(null);
        }
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketGetInfo(world.field_73011_w.getDimension(), blockPos, mode, mouseOver, pickBlock));
    }

    public static void renderOverlay(IOverlayStyle style, IProbeInfo probeInfo) {
        GlStateManager.func_179094_E();
        double scale = Config.getTooltipScale();
        ScaledResolution scaledresolution = new ScaledResolution(ClientTools.mc);
        double sw = scaledresolution.func_78327_c();
        double sh = scaledresolution.func_78324_d();
        OverlayRenderer.setupOverlayRendering(sw * scale, sh * scale);
        OverlayRenderer.renderElements((ProbeInfo)probeInfo, style, sw * scale, sh * scale, null);
        OverlayRenderer.setupOverlayRendering(sw, sh);
        GlStateManager.func_179121_F();
    }

    private static void cleanupCachedBlocks(long time) {
        HashMap<Pair<Integer, BlockPos>, Pair<Long, ProbeInfo>> newCachedInfo = new HashMap<Pair<Integer, BlockPos>, Pair<Long, ProbeInfo>>();
        for (Map.Entry<Pair<Integer, BlockPos>, Pair<Long, ProbeInfo>> entry : cachedInfo.entrySet()) {
            long t = (Long)entry.getValue().getLeft();
            if (time >= t + (long)Config.timeout + 1000L) continue;
            newCachedInfo.put(entry.getKey(), entry.getValue());
        }
        cachedInfo = newCachedInfo;
    }

    private static void cleanupCachedEntities(long time) {
        HashMap<UUID, Pair<Long, ProbeInfo>> newCachedInfo = new HashMap<UUID, Pair<Long, ProbeInfo>>();
        for (Map.Entry<UUID, Pair<Long, ProbeInfo>> entry : cachedEntityInfo.entrySet()) {
            long t = (Long)entry.getValue().getLeft();
            if (time >= t + (long)Config.timeout + 1000L) continue;
            newCachedInfo.put(entry.getKey(), entry.getValue());
        }
        cachedEntityInfo = newCachedInfo;
    }

    public static void renderElements(ProbeInfo probeInfo, IOverlayStyle style, double sw, double sh, @Nullable IElement extra) {
        if (extra != null) {
            probeInfo.element(extra);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        int scaledWidth = (int)sw;
        int scaledHeight = (int)sh;
        int w = probeInfo.getWidth();
        int h = probeInfo.getHeight();
        int offset = style.getBorderOffset();
        int thick = style.getBorderThickness();
        int margin = 0;
        if (thick > 0) {
            w += (offset + thick + 3) * 2;
            h += (offset + thick + 3) * 2;
            margin = offset + thick + 3;
        }
        int x = style.getLeftX() != -1 ? (int)((double)scaledWidth * ((double)style.getLeftX() / 100.0)) : (style.getRightX() != -1 ? (int)((double)(scaledWidth - w) - (double)scaledWidth * ((double)style.getRightX() / 100.0)) : (scaledWidth - w) / 2);
        int y = style.getTopY() != -1 ? (int)((double)scaledHeight * ((double)style.getTopY() / 100.0)) : (style.getBottomY() != -1 ? (int)((double)(scaledHeight - h) - (double)scaledHeight * ((double)style.getBottomY() / 100.0)) : (scaledHeight - h) / 2);
        if (thick > 0) {
            if (offset > 0) {
                RenderHelper.drawThickBeveledBox(x, y, x + w - 1, y + h - 1, thick, style.getBoxColor(), style.getBoxColor(), style.getBoxColor());
            }
            RenderHelper.drawThickBeveledBox(x + offset, y + offset, x + w - 1 - offset, y + h - 1 - offset, thick, style.getBorderColor(), style.getBorderColor(), style.getBoxColor());
        }
        if (!ClientTools.mc.func_147113_T()) {
            RenderHelper.rot += 0.5f;
        }
        probeInfo.render(x + margin, y + margin);
        if (extra != null) {
            probeInfo.removeElement(extra);
        }
    }

    static {
        lastPairTime = 0L;
        lastRenderedTime = -1L;
    }
}

