/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.rendering;

import java.awt.Color;
import java.awt.image.BufferedImage;
import mcjty.theoneprobe.TheOneProbe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;

public class TextureGenerator {
    public static ResourceLocation generateTexture(String name, int width, int height, PatternType pattern, Color color1, Color color2, int patternSize) {
        TheOneProbe.setup.getLogger().info("Creating Texture: {}", (Object)name);
        BufferedImage image = new BufferedImage(width, height, 2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Color pixelColor;
                switch (pattern) {
                    case CHECKERBOARD: {
                        pixelColor = (x / patternSize + y / patternSize) % 2 == 0 ? color1 : color2;
                        break;
                    }
                    case NOISE: {
                        double noiseValue = Math.random();
                        if (noiseValue < 0.2) {
                            pixelColor = TextureGenerator.darken(color1, 0.3f);
                            break;
                        }
                        if (noiseValue < 0.4) {
                            pixelColor = TextureGenerator.darken(color1, 0.15f);
                            break;
                        }
                        if (noiseValue < 0.6) {
                            pixelColor = color1;
                            break;
                        }
                        if (noiseValue < 0.8) {
                            pixelColor = TextureGenerator.brighten(color1, 0.15f);
                            break;
                        }
                        pixelColor = TextureGenerator.brighten(color1, 0.3f);
                        break;
                    }
                    case OUTLINE: {
                        int outlineThickness = patternSize > 0 ? patternSize : 1;
                        boolean isBorder = x < outlineThickness || y < outlineThickness || x >= width - outlineThickness || y >= height - outlineThickness;
                        pixelColor = isBorder ? color1 : new Color(0, 0, 0, 0);
                        break;
                    }
                    case GRADIENT: {
                        float ratio = (float)y / (float)height;
                        int r = (int)((float)color1.getRed() * (1.0f - ratio) + (float)color2.getRed() * ratio);
                        int g = (int)((float)color1.getGreen() * (1.0f - ratio) + (float)color2.getGreen() * ratio);
                        int b = (int)((float)color1.getBlue() * (1.0f - ratio) + (float)color2.getBlue() * ratio);
                        int a = (int)((float)color1.getAlpha() * (1.0f - ratio) + (float)color2.getAlpha() * ratio);
                        pixelColor = new Color(r, g, b, a);
                        break;
                    }
                    case GUI_BACKGROUND: {
                        int border = 2;
                        pixelColor = color1;
                        if (x < border || y < border) {
                            pixelColor = TextureGenerator.brighten(pixelColor, 0.4f);
                        }
                        if (x >= width - border || y >= height - border) {
                            pixelColor = TextureGenerator.darken(pixelColor, 0.4f);
                        }
                        if ((x == border || y == border) && x < width - border && y < height - border) {
                            pixelColor = TextureGenerator.brighten(pixelColor, 0.2f);
                            break;
                        }
                        if (x != width - border - 1 && y != height - border - 1 || x < border || y < border) break;
                        pixelColor = TextureGenerator.darken(pixelColor, 0.2f);
                        break;
                    }
                    case GUI_BUTTON: {
                        float gradientRatio = (float)y / (float)height;
                        int rBtn = (int)((float)color1.getRed() * (1.0f - gradientRatio) + (float)color2.getRed() * gradientRatio);
                        int gBtn = (int)((float)color1.getGreen() * (1.0f - gradientRatio) + (float)color2.getGreen() * gradientRatio);
                        int bBtn = (int)((float)color1.getBlue() * (1.0f - gradientRatio) + (float)color2.getBlue() * gradientRatio);
                        int aBtn = (int)((float)color1.getAlpha() * (1.0f - gradientRatio) + (float)color2.getAlpha() * gradientRatio);
                        pixelColor = new Color(rBtn, gBtn, bBtn, aBtn);
                        if (x < patternSize || y < patternSize) {
                            pixelColor = TextureGenerator.brighten(pixelColor, 0.2f);
                        } else if (x >= width - patternSize || y >= height - patternSize) {
                            pixelColor = TextureGenerator.darken(pixelColor, 0.2f);
                        }
                        if (y >= height / 3) break;
                        pixelColor = TextureGenerator.brighten(pixelColor, 0.05f);
                        break;
                    }
                    default: {
                        pixelColor = color1;
                    }
                }
                image.setRGB(x, y, pixelColor.getRGB());
            }
        }
        DynamicTexture dynamicTexture = new DynamicTexture(image);
        return Minecraft.func_71410_x().func_110434_K().func_110578_a(name, dynamicTexture);
    }

    private static Color brighten(Color color, float amount) {
        int r = Math.min(255, (int)((float)color.getRed() * (1.0f + amount)));
        int g = Math.min(255, (int)((float)color.getGreen() * (1.0f + amount)));
        int b = Math.min(255, (int)((float)color.getBlue() * (1.0f + amount)));
        return new Color(r, g, b, color.getAlpha());
    }

    private static Color darken(Color color, float amount) {
        int r = Math.max(0, (int)((float)color.getRed() * (1.0f - amount)));
        int g = Math.max(0, (int)((float)color.getGreen() * (1.0f - amount)));
        int b = Math.max(0, (int)((float)color.getBlue() * (1.0f - amount)));
        return new Color(r, g, b, color.getAlpha());
    }

    public static enum PatternType {
        CHECKERBOARD,
        NOISE,
        OUTLINE,
        SOLID,
        GRADIENT,
        GUI_BACKGROUND,
        GUI_BUTTON;

    }
}

