/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrbysco.lunar.api.ILunarEvent;
import com.mrbysco.lunar.platform.Services;
import com.mrbysco.lunar.registry.LunarRegistry;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_26;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LunarPhaseData
extends class_18 {
    private static final Random random = new Random();
    private static final String DATA_NAME = "lunar_world_data";
    public static final Codec<LunarPhaseData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.optionalFieldOf("forcedEvent").forGetter(data -> data.forcedEventID), (App)class_2960.field_25139.optionalFieldOf("activeEvent").forGetter(data -> data.activeEventID)).apply((Applicative)instance, LunarPhaseData::new));
    public Optional<class_2960> forcedEventID;
    public Optional<class_2960> activeEventID;
    public ILunarEvent forcedEvent;
    public ILunarEvent activeEvent;

    private LunarPhaseData() {
        this(Optional.empty(), Optional.empty());
    }

    public LunarPhaseData(Optional<class_2960> forcedEventID, Optional<class_2960> activeEventID) {
        this.forcedEventID = activeEventID;
        ILunarEvent event = activeEventID.map(location -> LunarRegistry.instance().getEventByID((class_2960)location)).orElse(null);
        this.setActiveEvent(event);
        this.activeEventID = forcedEventID;
        ILunarEvent forcedEvent = forcedEventID.map(location -> LunarRegistry.instance().getEventByID((class_2960)location)).orElse(null);
        this.setForcedEvent(forcedEvent);
    }

    public static class_10741<LunarPhaseData> type() {
        return new class_10741(DATA_NAME, LunarPhaseData::new, CODEC, null);
    }

    public static LunarPhaseData get(class_1937 level) {
        if (!(level instanceof class_3218)) {
            throw new RuntimeException("Attempted to get the data from a client world. This is wrong.");
        }
        class_3218 overworld = level.method_8503().method_3847(class_1937.field_25179);
        assert (overworld != null);
        class_26 storage = overworld.method_17983();
        return (LunarPhaseData)storage.method_17924(LunarPhaseData.type());
    }

    public void setRandomLunarEvent(@NotNull class_3218 serverLevel) {
        if (this.forcedEvent != null) {
            class_5250 startComponent = class_2561.method_43469((String)"lunar.event.start", (Object[])new Object[]{class_2561.method_43471((String)this.forcedEvent.getTranslationKey())});
            serverLevel.method_18456().forEach(arg_0 -> LunarPhaseData.lambda$setRandomLunarEvent$5((class_2561)startComponent, arg_0));
            this.setActiveEvent(this.forcedEvent);
            this.setForcedEvent(null);
        } else {
            ILunarEvent event;
            float rng = random.nextFloat();
            if (rng <= Services.PLATFORM.getLunarChance() && (event = LunarRegistry.instance().getRandomLunarEvent((class_1937)serverLevel)) != null) {
                class_5250 startComponent = class_2561.method_43469((String)"lunar.event.start", (Object[])new Object[]{class_2561.method_43471((String)event.getTranslationKey())});
                serverLevel.method_18456().forEach(arg_0 -> LunarPhaseData.lambda$setRandomLunarEvent$6((class_2561)startComponent, arg_0));
                this.setActiveEvent(event);
                return;
            }
            this.setDefaultMoon();
        }
    }

    public void setForcedEvent(@Nullable ILunarEvent event) {
        this.forcedEvent = event;
        this.forcedEventID = Optional.ofNullable(event != null ? event.getID() : null);
        this.method_80();
    }

    public void eraseEvent() {
        this.setActiveEvent(null);
    }

    public void setDefaultMoon() {
        this.setActiveEvent(LunarRegistry.getDefaultMoon());
        this.setForcedEvent(null);
    }

    public void setActiveEvent(@Nullable ILunarEvent event) {
        this.activeEvent = event;
        this.activeEventID = Optional.ofNullable(event != null ? event.getID() : null);
        this.method_80();
    }

    public void syncEvent(class_1937 level) {
        Services.PLATFORM.syncEvent(level, this.activeEvent != null ? this.activeEvent : null);
    }

    public void syncEvent(class_3222 player) {
        Services.PLATFORM.syncEvent(player, this.activeEvent != null ? this.activeEvent : null);
    }

    public ILunarEvent getActiveLunarEvent() {
        return this.activeEvent != null ? this.activeEvent : null;
    }

    public boolean hasEventActive() {
        return this.activeEvent != null;
    }

    private static /* synthetic */ void lambda$setRandomLunarEvent$6(class_2561 startComponent, class_3222 player) {
        player.method_64398(startComponent);
    }

    private static /* synthetic */ void lambda$setRandomLunarEvent$5(class_2561 startComponent, class_3222 player) {
        player.method_64398(startComponent);
    }
}

