/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class MoonHandler {
    private static String moonID = null;
    private static int rawMoonColor = 0xFFFFFF;
    private static float[] moonColor = null;
    private static float rawMoonScale = 1.0f;
    private static Matrix4f moonScale;
    private static AbstractTexture moonTexture;

    public static Vector4fc colorTheMoon(Vector4fc originalColor) {
        if (MoonHandler.isEventActive()) {
            int color = MoonHandler.getMoonColor();
            return new Vector4f(ARGB.redFloat((int)color), ARGB.greenFloat((int)color), ARGB.blueFloat((int)color), originalColor.w());
        }
        return originalColor;
    }

    public static void setMoon(String eventID, int color, float scale) {
        rawMoonColor = color;
        float r = ARGB.redFloat((int)color);
        float g = ARGB.greenFloat((int)color);
        float b = ARGB.blueFloat((int)color);
        moonColor = new float[]{r, g, b};
        moonID = eventID;
        if (scale != 1.0f) {
            rawMoonScale = scale;
            moonScale = new Matrix4f().scale(scale, 1.0f, scale);
        }
    }

    public static void setMoonTexture(@Nullable ResourceLocation textureLocation) {
        moonTexture = MoonHandler.getTexture(textureLocation);
    }

    public static void disableMoon() {
        moonColor = null;
        moonID = null;
        moonScale = null;
        moonTexture = null;
    }

    public static boolean isEventActive() {
        return moonID != null && moonColor != null;
    }

    public static boolean isMoonScaled() {
        return moonScale != null;
    }

    public static AbstractTexture getMoonTexture(AbstractTexture defaultTexture) {
        if (moonTexture != null) {
            return moonTexture;
        }
        return defaultTexture;
    }

    public static Matrix4f getMoonScale() {
        return moonScale;
    }

    public static Matrix4f scaleMoon(Matrix4f matrix) {
        return matrix;
    }

    public static int getMoonColor() {
        return rawMoonColor;
    }

    public static float getRawMoonScale() {
        return rawMoonScale;
    }

    private static AbstractTexture getTexture(ResourceLocation location) {
        TextureManager texturemanager = Minecraft.getInstance().getTextureManager();
        AbstractTexture abstracttexture = texturemanager.getTexture(location);
        abstracttexture.setUseMipmaps(false);
        return abstracttexture;
    }
}

