/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.network.handler;

import com.mrbysco.lunar.client.MoonHandler;
import com.mrbysco.lunar.network.message.SyncEventMessage;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ClientPayloadHandler {
    private static final ClientPayloadHandler INSTANCE = new ClientPayloadHandler();

    public static ClientPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleSync(SyncEventMessage payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            MoonHandler.disableMoon();
            if (payload.color() != -1 && !payload.eventID().isBlank()) {
                MoonHandler.setMoon(payload.eventID(), payload.color(), payload.moonScale());
                if (payload.customTexture() != null) {
                    MoonHandler.setMoonTexture(payload.customTexture());
                }
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"lunar.networking.sync_event.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

