/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.registry.events;

import com.mrbysco.lunar.Constants;
import com.mrbysco.lunar.api.LunarEvent;
import com.mrbysco.lunar.handler.result.EventResult;
import com.mrbysco.lunar.platform.Services;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.tuple.Pair;

public class BigMoonEvent
extends LunarEvent {
    private static final ResourceLocation MOON_TEXTURE = Constants.modLoc("textures/environment/big.png");
    private static final Pair<Holder<Attribute>, ResourceLocation> BIG_MOON_MODIFIER_PAIR = Pair.of((Object)Attributes.GRAVITY, (Object)Constants.modLoc("big_moon_modifier"));

    public BigMoonEvent() {
        super(Constants.modLoc("big_moon"), 0xFFFFF1);
    }

    @Override
    public int spawnWeight() {
        return Services.PLATFORM.getBigMoonWeight();
    }

    @Override
    public String getTranslationKey() {
        return "lunar.event.big_moon";
    }

    @Override
    public boolean applyEntityEffect() {
        return true;
    }

    @Override
    public void applyEntityEffect(Entity entity) {
        LivingEntity livingEntity;
        AttributeInstance attributeInstance;
        if (entity instanceof LivingEntity && (attributeInstance = (livingEntity = (LivingEntity)entity).getAttribute((Holder)BIG_MOON_MODIFIER_PAIR.getLeft())) != null && !attributeInstance.hasModifier((ResourceLocation)BIG_MOON_MODIFIER_PAIR.getRight())) {
            attributeInstance.addPermanentModifier(new AttributeModifier((ResourceLocation)BIG_MOON_MODIFIER_PAIR.getRight(), (double)0.04f, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    @Override
    public void removeEntityEffect(Entity entity) {
        LivingEntity livingEntity;
        AttributeInstance attributeInstance;
        if (entity instanceof LivingEntity && (attributeInstance = (livingEntity = (LivingEntity)entity).getAttribute((Holder)BIG_MOON_MODIFIER_PAIR.getLeft())) != null && attributeInstance.hasModifier((ResourceLocation)BIG_MOON_MODIFIER_PAIR.getRight())) {
            attributeInstance.removeModifier((ResourceLocation)BIG_MOON_MODIFIER_PAIR.getRight());
        }
    }

    @Override
    public List<Pair<Holder<Attribute>, ResourceLocation>> getAttributePairs() {
        return List.of(BIG_MOON_MODIFIER_PAIR);
    }

    @Override
    public ResourceLocation moonTexture() {
        return MOON_TEXTURE;
    }

    @Override
    public float moonScale() {
        return 4.0f;
    }

    @Override
    public EventResult canSleep(Player player, BlockPos sleepingLocation) {
        if (!Services.PLATFORM.canSleepIn(this.getID())) {
            return EventResult.DENY;
        }
        return EventResult.DEFAULT;
    }
}

