/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar;

import com.mojang.brigadier.CommandDispatcher;
import com.mrbysco.lunar.CommonClass;
import com.mrbysco.lunar.LunarPhaseData;
import com.mrbysco.lunar.commands.LunarCommands;
import com.mrbysco.lunar.config.LunarConfig;
import com.mrbysco.lunar.handler.LunarHandler;
import com.mrbysco.lunar.handler.result.EventResult;
import com.mrbysco.lunar.network.PacketHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;
import net.neoforged.neoforge.event.entity.player.CanContinueSleepingEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@Mod(value="lunar")
public class Lunar {
    public Lunar(IEventBus eventBus, ModContainer container, Dist dist) {
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)LunarConfig.commonSpec);
        eventBus.addListener(this::setup);
        eventBus.addListener(PacketHandler::setupPackets);
        NeoForge.EVENT_BUS.addListener(this::onSleepCheck);
        NeoForge.EVENT_BUS.addListener(this::onLivingSpawn);
        NeoForge.EVENT_BUS.addListener(this::onCheckSpawn);
        NeoForge.EVENT_BUS.addListener(this::onLevelTick);
        NeoForge.EVENT_BUS.addListener(this::onLogin);
        NeoForge.EVENT_BUS.addListener(this::onCommandRegister);
        if (dist.isClient()) {
            container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        CommonClass.initRegistry();
    }

    public void onCommandRegister(RegisterCommandsEvent event) {
        LunarCommands.initializeCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void onSleepCheck(CanContinueSleepingEvent event) {
        EventResult result;
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).level().dimension().equals(Level.OVERWORLD) && player.getSleepingPos().isPresent() && (result = LunarHandler.canSleep(player, (BlockPos)player.getSleepingPos().get())) != EventResult.DEFAULT) {
            event.setContinueSleeping(result == EventResult.DENY ? false : event.mayContinueSleeping());
        }
    }

    private void onLivingSpawn(FinalizeSpawnEvent event) {
        if (event.getEntity().level().dimension().equals(Level.OVERWORLD)) {
            LunarHandler.uponLivingSpawn(event.getSpawnType(), (LivingEntity)event.getEntity());
        }
    }

    private void onCheckSpawn(MobSpawnEvent.PositionCheck event) {
        EventResult spawnResult;
        if (event.getLevel().getLevel().dimension().equals(Level.OVERWORLD) && (spawnResult = LunarHandler.getSpawnResult(event.getSpawnType(), (LivingEntity)event.getEntity())) != EventResult.DEFAULT) {
            if (spawnResult == EventResult.ALLOW) {
                event.setResult(MobSpawnEvent.PositionCheck.Result.SUCCEED);
            } else {
                event.setResult(MobSpawnEvent.PositionCheck.Result.FAIL);
            }
        }
    }

    private void onLevelTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (serverLevel.dimension().equals(Level.OVERWORLD)) {
                LunarHandler.onOverworldTick((Level)serverLevel);
            } else {
                LunarHandler.onLevelTick((Level)serverLevel);
            }
        }
    }

    public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        Level level = player.level();
        if (!level.isClientSide) {
            LunarPhaseData phaseData = LunarPhaseData.get(player.level());
            phaseData.syncEvent((ServerPlayer)player);
        }
    }
}

