/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mrbysco.lunar.LunarPhaseData;
import com.mrbysco.lunar.api.ILunarEvent;
import com.mrbysco.lunar.registry.LunarRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class LunarCommands {
    public static void initializeCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder root = Commands.literal((String)"lunar");
        ((LiteralArgumentBuilder)root.requires(sourceStack -> sourceStack.hasPermission(2))).then(Commands.literal((String)"forceEvent").then(((RequiredArgumentBuilder)Commands.argument((String)"eventID", (ArgumentType)ResourceLocationArgument.id()).suggests((cs, builder) -> SharedSuggestionProvider.suggest(LunarRegistry.instance().getIDList(), (SuggestionsBuilder)builder)).executes(ctx -> LunarCommands.forceEvent((CommandContext<CommandSourceStack>)ctx, false))).then(Commands.argument((String)"forceCurrent", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> LunarCommands.forceEvent((CommandContext<CommandSourceStack>)ctx, BoolArgumentType.getBool((CommandContext)ctx, (String)"forceCurrent"))))));
        ((LiteralArgumentBuilder)root.requires(sourceStack -> sourceStack.hasPermission(2))).then(Commands.literal((String)"skip").executes(LunarCommands::skipEvent));
        ((LiteralArgumentBuilder)root.requires(sourceStack -> sourceStack.hasPermission(2))).then(Commands.literal((String)"randomize").executes(LunarCommands::randomizeEvent));
        dispatcher.register(root);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int forceEvent(CommandContext<CommandSourceStack> ctx, boolean forceCurrent) {
        ResourceLocation eventID = ResourceLocationArgument.getId(ctx, (String)"eventID");
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).getServer().getLevel(Level.OVERWORLD);
        LunarPhaseData phaseData = LunarPhaseData.get((Level)level);
        ILunarEvent event = LunarRegistry.instance().getEventByID(eventID);
        if (event == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("No lunar event found with ID: " + String.valueOf(eventID))));
            return 0;
        }
        if (!forceCurrent) {
            phaseData.setForcedEvent(event);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Successfully forced a ").append((Component)Component.translatable((String)event.getTranslationKey()).withStyle(ChatFormatting.GOLD)).append(" next night"), true);
            return 0;
        }
        int currentTime = (int)(level.getDayTime() % 24000L);
        if (currentTime > 13000 && currentTime < 23000) {
            ILunarEvent activeEvent = phaseData.getActiveLunarEvent();
            if (activeEvent != null) {
                LunarCommands.stopEvent(level, activeEvent);
            }
            phaseData.setActiveEvent(event);
            phaseData.syncEvent((Level)level);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Successfully forced a ").append((Component)Component.translatable((String)event.getTranslationKey()).withStyle(ChatFormatting.GOLD)).append(" tonight"), true);
            return 0;
        }
        ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"You can only force an event to occur at night!"));
        return 0;
    }

    private static int skipEvent(CommandContext<CommandSourceStack> ctx) {
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).getServer().getLevel(Level.OVERWORLD);
        LunarPhaseData phaseData = LunarPhaseData.get((Level)level);
        ILunarEvent event = phaseData.getActiveLunarEvent();
        if (event == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"There is no active lunar event to skip tonight!"));
            return 0;
        }
        LunarCommands.stopEvent(level, event);
        phaseData.setDefaultMoon();
        phaseData.syncEvent((Level)level);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Successfully skipped the lunar event for tonight"), true);
        return 0;
    }

    private static int randomizeEvent(CommandContext<CommandSourceStack> ctx) {
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).getServer().getLevel(Level.OVERWORLD);
        LunarPhaseData phaseData = LunarPhaseData.get((Level)level);
        int currentTime = (int)(level.getDayTime() % 24000L);
        if (currentTime > 13000 && currentTime < 23000) {
            ILunarEvent event = phaseData.getActiveLunarEvent();
            if (event != null) {
                LunarCommands.stopEvent(level, event);
            }
        } else {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"You can only randomize an event to occur at night!"));
            return 0;
        }
        phaseData.setRandomLunarEvent((Level)level);
        phaseData.syncEvent((Level)level);
        ILunarEvent newEvent = phaseData.getActiveLunarEvent();
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Successfully randomized the lunar event for tonight to ").append((Component)Component.translatable((String)newEvent.getTranslationKey()).withStyle(ChatFormatting.GOLD)), true);
        return 0;
    }

    private static void stopEvent(@NotNull ServerLevel level, @NotNull ILunarEvent event) {
        if (event.applyEntityEffect()) {
            level.getAllEntities().forEach(entity -> {
                if (entity.isSpectator()) {
                    return;
                }
                event.removeEntityEffect((Entity)entity);
            });
        }
        if (event.applyPlayerEffect()) {
            level.players().forEach(event::removePlayerEffect);
        }
        for (Pair<Holder<Attribute>, ResourceLocation> modifierPair : LunarRegistry.instance().getEventModifiers()) {
            level.getAllEntities().forEach(entity -> {
                if (entity instanceof LivingEntity) {
                    AttributeInstance modifier;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    if (!entity.isSpectator() && (modifier = livingEntity.getAttribute((Holder)modifierPair.getLeft())) != null) {
                        modifier.removeModifier((ResourceLocation)modifierPair.getRight());
                    }
                }
            });
        }
    }
}

