/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.network.message;

import com.mrbysco.lunar.Constants;
import com.mrbysco.lunar.api.ILunarEvent;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public record SyncEventMessage(int color, String eventID, float moonScale, ResourceLocation customTexture) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, SyncEventMessage> CODEC = CustomPacketPayload.codec(SyncEventMessage::write, SyncEventMessage::new);
    public static final CustomPacketPayload.Type<SyncEventMessage> ID = new CustomPacketPayload.Type(Constants.SYNC_EVENT_ID);

    public SyncEventMessage(ILunarEvent event) {
        this(event != null ? event.moonColor() : -1, event != null ? event.getID().toString() : "", event != null ? event.moonScale() : 1.0f, event != null ? event.moonTexture() : null);
    }

    public SyncEventMessage(int color, String eventName, float scale, String moonTexture) {
        this(color, eventName, scale, moonTexture == null || moonTexture.isEmpty() ? null : ResourceLocation.tryParse((String)moonTexture));
    }

    public SyncEventMessage(FriendlyByteBuf buffer) {
        this(buffer.readInt(), buffer.readUtf(), buffer.readFloat(), buffer.readUtf());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.color);
        buffer.writeUtf(this.eventID);
        buffer.writeFloat(this.moonScale);
        buffer.writeUtf(this.customTexture == null ? "" : this.customTexture.toString());
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

