/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.registry.events;

import com.mrbysco.lunar.Constants;
import com.mrbysco.lunar.api.LunarEvent;
import com.mrbysco.lunar.handler.result.EventResult;
import com.mrbysco.lunar.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;

public class BadOmenMoonEvent
extends LunarEvent {
    private static final ResourceLocation MOON_TEXTURE = Constants.modLoc("textures/environment/bad_omen.png");

    public BadOmenMoonEvent() {
        super(Constants.modLoc("bad_omen_moon"), 11409945);
    }

    @Override
    public int spawnWeight() {
        return Services.PLATFORM.getBadOmenMoonWeight();
    }

    @Override
    public String getTranslationKey() {
        return "lunar.event.bad_omen_moon";
    }

    @Override
    public boolean applyPlayerEffect() {
        return true;
    }

    @Override
    public void applyPlayerEffect(Player player) {
        ServerPlayer serverPlayer;
        ServerLevel serverLevel;
        if (player instanceof ServerPlayer && !(serverLevel = (serverPlayer = (ServerPlayer)player).serverLevel()).isRaided(player.blockPosition())) {
            int maxLevel = Services.PLATFORM.maxBadOmen();
            int randomLevel = serverPlayer.getRandom().nextInt(maxLevel);
            player.addEffect(new MobEffectInstance(MobEffects.BAD_OMEN, 40, randomLevel, false, true));
        }
    }

    @Override
    public ResourceLocation moonTexture() {
        return MOON_TEXTURE;
    }

    @Override
    public EventResult canSleep(Player player, BlockPos sleepingLocation) {
        if (!Services.PLATFORM.canSleepIn(this.getID())) {
            return EventResult.DENY;
        }
        return EventResult.DEFAULT;
    }
}

