/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.registry.events;

import com.mrbysco.lunar.Constants;
import com.mrbysco.lunar.api.LunarEvent;
import com.mrbysco.lunar.handler.result.EventResult;
import com.mrbysco.lunar.platform.Services;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;

public class CrimsonMoonEvent
extends LunarEvent {
    private static final ResourceLocation MOON_TEXTURE = Constants.modLoc("textures/environment/crimson.png");

    public CrimsonMoonEvent() {
        super(Constants.modLoc("crimson_moon"), 14423100);
    }

    @Override
    public int spawnWeight() {
        return Services.PLATFORM.getCrimsonMoonWeight();
    }

    @Override
    public String getTranslationKey() {
        return "lunar.event.crimson_moon";
    }

    @Override
    public EventResult canSleep(Player player, BlockPos sleepingLocation) {
        if (!Services.PLATFORM.canSleepIn(this.getID())) {
            return EventResult.DENY;
        }
        return EventResult.DEFAULT;
    }

    @Override
    public boolean dictatesMobSpawn() {
        return true;
    }

    @Override
    public ResourceLocation moonTexture() {
        return MOON_TEXTURE;
    }

    @Override
    public EventResult getSpawnResult(LivingEntity livingEntity, MobSpawnType spawnType) {
        Entity replacementEntity;
        EntityType replacementType;
        ResourceLocation replacementLocation;
        ResourceLocation entityLocation;
        Map<ResourceLocation, ResourceLocation> replacementMap;
        ServerLevel level = (ServerLevel)livingEntity.level();
        if (spawnType == MobSpawnType.NATURAL && (replacementMap = Services.PLATFORM.getCrimsonReplacementMap()).containsKey(entityLocation = BuiltInRegistries.ENTITY_TYPE.getKey((Object)livingEntity.getType())) && (replacementLocation = replacementMap.get(entityLocation)) != null && (replacementType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(replacementLocation)) != null && (replacementEntity = replacementType.create((Level)level)) != null) {
            BlockPos position = livingEntity.blockPosition();
            replacementEntity.moveTo(position, livingEntity.getYRot(), livingEntity.getXRot());
            if (replacementEntity instanceof Mob) {
                Mob mob = (Mob)replacementEntity;
                if (!mob.checkSpawnObstruction((LevelReader)level)) {
                    return EventResult.DEFAULT;
                }
                mob.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(position), MobSpawnType.NATURAL, null);
            }
            if (replacementEntity instanceof Ghast) {
                if (level.random.nextDouble() <= 0.5) {
                    level.addFreshEntity(replacementEntity);
                }
                livingEntity.discard();
            } else {
                level.addFreshEntity(replacementEntity);
                livingEntity.discard();
            }
            return EventResult.DENY;
        }
        return EventResult.DEFAULT;
    }
}

