/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrbysco.lunar.api.ILunarEvent;
import com.mrbysco.lunar.platform.Services;
import com.mrbysco.lunar.registry.LunarRegistry;
import java.util.Optional;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LunarPhaseData
extends SavedData {
    private static final Random random = new Random();
    private static final String DATA_NAME = "lunar_world_data";
    public static final Codec<LunarPhaseData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.optionalFieldOf("forcedEvent").forGetter(data -> data.forcedEventID), (App)ResourceLocation.CODEC.optionalFieldOf("activeEvent").forGetter(data -> data.activeEventID)).apply((Applicative)instance, LunarPhaseData::new));
    public Optional<ResourceLocation> forcedEventID;
    public Optional<ResourceLocation> activeEventID;
    public ILunarEvent forcedEvent;
    public ILunarEvent activeEvent;

    private LunarPhaseData() {
        this(Optional.empty(), Optional.empty());
    }

    public LunarPhaseData(Optional<ResourceLocation> forcedEventID, Optional<ResourceLocation> activeEventID) {
        this.forcedEventID = activeEventID;
        ILunarEvent event = activeEventID.map(location -> LunarRegistry.instance().getEventByID((ResourceLocation)location)).orElse(null);
        this.setActiveEvent(event);
        this.activeEventID = forcedEventID;
        ILunarEvent forcedEvent = forcedEventID.map(location -> LunarRegistry.instance().getEventByID((ResourceLocation)location)).orElse(null);
        this.setForcedEvent(forcedEvent);
    }

    public static SavedDataType<LunarPhaseData> type() {
        return new SavedDataType(DATA_NAME, LunarPhaseData::new, CODEC, null);
    }

    public static LunarPhaseData get(Level level) {
        if (!(level instanceof ServerLevel)) {
            throw new RuntimeException("Attempted to get the data from a client world. This is wrong.");
        }
        ServerLevel overworld = level.getServer().getLevel(Level.OVERWORLD);
        assert (overworld != null);
        DimensionDataStorage storage = overworld.getDataStorage();
        return (LunarPhaseData)storage.computeIfAbsent(LunarPhaseData.type());
    }

    public void setRandomLunarEvent(@NotNull ServerLevel serverLevel) {
        if (this.forcedEvent != null) {
            MutableComponent startComponent = Component.translatable((String)"lunar.event.start", (Object[])new Object[]{Component.translatable((String)this.forcedEvent.getTranslationKey())});
            serverLevel.players().forEach(arg_0 -> LunarPhaseData.lambda$setRandomLunarEvent$5((Component)startComponent, arg_0));
            this.setActiveEvent(this.forcedEvent);
            this.setForcedEvent(null);
        } else {
            ILunarEvent event;
            float rng = random.nextFloat();
            if (rng <= Services.PLATFORM.getLunarChance() && (event = LunarRegistry.instance().getRandomLunarEvent((Level)serverLevel)) != null) {
                MutableComponent startComponent = Component.translatable((String)"lunar.event.start", (Object[])new Object[]{Component.translatable((String)event.getTranslationKey())});
                serverLevel.players().forEach(arg_0 -> LunarPhaseData.lambda$setRandomLunarEvent$6((Component)startComponent, arg_0));
                this.setActiveEvent(event);
                return;
            }
            this.setDefaultMoon();
        }
    }

    public void setForcedEvent(@Nullable ILunarEvent event) {
        this.forcedEvent = event;
        this.forcedEventID = Optional.ofNullable(event != null ? event.getID() : null);
        this.setDirty();
    }

    public void eraseEvent() {
        this.setActiveEvent(null);
    }

    public void setDefaultMoon() {
        this.setActiveEvent(LunarRegistry.getDefaultMoon());
        this.setForcedEvent(null);
    }

    public void setActiveEvent(@Nullable ILunarEvent event) {
        this.activeEvent = event;
        this.activeEventID = Optional.ofNullable(event != null ? event.getID() : null);
        this.setDirty();
    }

    public void syncEvent(Level level) {
        Services.PLATFORM.syncEvent(level, this.activeEvent != null ? this.activeEvent : null);
    }

    public void syncEvent(ServerPlayer player) {
        Services.PLATFORM.syncEvent(player, this.activeEvent != null ? this.activeEvent : null);
    }

    public ILunarEvent getActiveLunarEvent() {
        return this.activeEvent != null ? this.activeEvent : null;
    }

    public boolean hasEventActive() {
        return this.activeEvent != null;
    }

    private static /* synthetic */ void lambda$setRandomLunarEvent$6(Component startComponent, ServerPlayer player) {
        player.sendSystemMessage(startComponent);
    }

    private static /* synthetic */ void lambda$setRandomLunarEvent$5(Component startComponent, ServerPlayer player) {
        player.sendSystemMessage(startComponent);
    }
}

