/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar;

import com.mojang.brigadier.CommandDispatcher;
import com.mrbysco.lunar.CommonClass;
import com.mrbysco.lunar.LunarPhaseData;
import com.mrbysco.lunar.commands.LunarCommands;
import com.mrbysco.lunar.config.LunarConfig;
import com.mrbysco.lunar.handler.LunarHandler;
import com.mrbysco.lunar.handler.result.EventResult;
import com.mrbysco.lunar.network.PacketHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="lunar")
public class Lunar {
    public Lunar() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)LunarConfig.commonSpec);
        eventBus.addListener(this::setup);
        MinecraftForge.EVENT_BUS.addListener(this::onSleepCheck);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingSpawn);
        MinecraftForge.EVENT_BUS.addListener(this::onCheckSpawn);
        MinecraftForge.EVENT_BUS.addListener(this::onLevelTick);
        MinecraftForge.EVENT_BUS.addListener(this::onLogin);
        MinecraftForge.EVENT_BUS.addListener(this::onCommandRegister);
    }

    private void setup(FMLCommonSetupEvent event) {
        PacketHandler.init();
        CommonClass.initRegistry();
    }

    public void onCommandRegister(RegisterCommandsEvent event) {
        LunarCommands.initializeCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void onSleepCheck(SleepingLocationCheckEvent event) {
        EventResult result;
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_9236_().m_46472_().equals((Object)Level.f_46428_) && (result = LunarHandler.canSleep(player, event.getSleepingLocation())) != EventResult.DEFAULT) {
            event.setResult(result == EventResult.DENY ? Event.Result.DENY : Event.Result.ALLOW);
        }
    }

    private void onLivingSpawn(MobSpawnEvent.FinalizeSpawn event) {
        if (event.getEntity().m_9236_().m_46472_().equals((Object)Level.f_46428_)) {
            LunarHandler.uponLivingSpawn(event.getSpawnType(), (LivingEntity)event.getEntity());
        }
    }

    private void onCheckSpawn(MobSpawnEvent.PositionCheck event) {
        EventResult spawnResult;
        if (event.getLevel().m_6018_().m_46472_().equals((Object)Level.f_46428_) && (spawnResult = LunarHandler.getSpawnResult(event.getSpawnType(), (LivingEntity)event.getEntity())) != EventResult.DEFAULT) {
            if (spawnResult == EventResult.ALLOW) {
                event.setResult(Event.Result.ALLOW);
            } else {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    private void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side.isServer() && event.level.m_46472_().equals((Object)Level.f_46428_)) {
            LunarHandler.onWorldTick(event.level);
        }
    }

    public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        Level level = player.m_9236_();
        if (!level.f_46443_) {
            LunarPhaseData phaseData = LunarPhaseData.get(player.m_9236_());
            phaseData.syncEvent((ServerPlayer)player);
        }
    }
}

