/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.api;

import com.mrbysco.lunar.handler.result.EventResult;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public interface ILunarEvent {
    public ResourceLocation getID();

    public String getTranslationKey();

    default public boolean canAppear(Level level) {
        return this.spawnWeight() > 0;
    }

    default public float moonScale() {
        return 1.0f;
    }

    default public ResourceLocation moonTexture() {
        return null;
    }

    public int spawnWeight();

    public int moonColor();

    default public EventResult getSpawnResult(LivingEntity livingEntity, MobSpawnType spawnType) {
        return EventResult.DEFAULT;
    }

    default public boolean dictatesMobSpawn() {
        return false;
    }

    default public void applySpawnEffect(LivingEntity livingEntity, MobSpawnType spawnType) {
    }

    default public boolean applySpawnEffect() {
        return false;
    }

    default public void applyEntityEffect(Entity entity) {
    }

    default public void removeEntityEffect(Entity entity) {
    }

    default public boolean applyEntityEffect() {
        return false;
    }

    default public void applyPlayerEffect(Player player) {
    }

    default public boolean applyPlayerEffect() {
        return false;
    }

    default public void stopEffects(Level level) {
    }

    default public EventResult canSleep(Player player, BlockPos sleepingLocation) {
        return EventResult.DEFAULT;
    }
}

