/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.client;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class MoonHandler {
    private static String moonID = null;
    private static int rawMoonColor = 0xFFFFFF;
    private static float[] moonColor = null;
    private static float rawMoonScale = 1.0f;
    private static Matrix4f moonScale;
    private static ResourceLocation moonTexture;

    public static int colorTheMoon(int originalColor) {
        if (MoonHandler.isEventActive()) {
            return ARGB.colorFromFloat((float)1.0f, (float)moonColor[0], (float)moonColor[1], (float)moonColor[2]);
        }
        return originalColor;
    }

    public static void setMoon(String eventID, int color, float scale) {
        rawMoonColor = color;
        int r = ARGB.red((int)color);
        int g = ARGB.green((int)color);
        int b = ARGB.blue((int)color);
        moonColor = new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
        moonID = eventID;
        if (scale != 1.0f) {
            rawMoonScale = scale;
            moonScale = new Matrix4f().scale(scale, 1.0f, scale);
        }
    }

    public static void setMoonTexture(@Nullable ResourceLocation location) {
        moonTexture = location;
    }

    public static void disableMoon() {
        moonColor = null;
        moonID = null;
        moonScale = null;
        moonTexture = null;
    }

    public static boolean isEventActive() {
        return moonID != null && moonColor != null;
    }

    public static boolean isMoonScaled() {
        return moonScale != null;
    }

    public static ResourceLocation getMoonTexture(ResourceLocation defaultTexture) {
        if (moonTexture != null) {
            return moonTexture;
        }
        return defaultTexture;
    }

    public static Matrix4f getMoonScale() {
        return moonScale;
    }

    public static Matrix4f scaleMoon(Matrix4f matrix) {
        return matrix;
    }

    public static int getMoonColor() {
        return rawMoonColor;
    }

    public static float getRawMoonScale() {
        return rawMoonScale;
    }
}

