/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.handler;

import com.mrbysco.lunar.LunarPhaseData;
import com.mrbysco.lunar.api.ILunarEvent;
import com.mrbysco.lunar.handler.result.EventResult;
import com.mrbysco.lunar.registry.LunarRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;

public class LunarHandler {
    public static void onOverworldTick(Level level) {
        block7: {
            ILunarEvent event;
            LunarPhaseData phaseData;
            ServerLevel serverLevel;
            block8: {
                block9: {
                    if (level.getGameTime() % 20L != 0L || !(level instanceof ServerLevel)) break block7;
                    serverLevel = (ServerLevel)level;
                    phaseData = LunarPhaseData.get((Level)serverLevel);
                    event = phaseData.getActiveLunarEvent();
                    int currentTime = (int)(serverLevel.getDayTime() % 24000L);
                    if (currentTime <= 13000 || currentTime >= 23000) break block8;
                    if (phaseData.hasEventActive()) break block9;
                    phaseData.setRandomLunarEvent(serverLevel);
                    phaseData.syncEvent((Level)serverLevel);
                    break block7;
                }
                if (event == null) break block7;
                if (event.applyEntityEffect()) {
                    serverLevel.getAllEntities().forEach(entity -> {
                        if (entity.isSpectator()) {
                            return;
                        }
                        event.applyEntityEffect((Entity)entity);
                    });
                }
                if (!event.applyPlayerEffect()) break block7;
                serverLevel.players().forEach(event::applyPlayerEffect);
                break block7;
            }
            if (phaseData.hasEventActive()) {
                if (event != null) {
                    if (event.applyEntityEffect()) {
                        serverLevel.getAllEntities().forEach(entity -> {
                            if (entity.isSpectator()) {
                                return;
                            }
                            event.removeEntityEffect((Entity)entity);
                        });
                    }
                    if (event.applyPlayerEffect()) {
                        serverLevel.players().forEach(event::removePlayerEffect);
                    }
                }
                phaseData.eraseEvent();
                phaseData.syncEvent((Level)serverLevel);
            } else {
                for (Pair<Holder<Attribute>, ResourceLocation> modifierPair : LunarRegistry.instance().getEventModifiers()) {
                    serverLevel.getAllEntities().forEach(entity -> {
                        if (entity instanceof LivingEntity) {
                            AttributeInstance modifier;
                            LivingEntity livingEntity = (LivingEntity)entity;
                            if (!entity.isSpectator() && (modifier = livingEntity.getAttribute((Holder)modifierPair.getLeft())) != null) {
                                modifier.removeModifier((ResourceLocation)modifierPair.getRight());
                            }
                        }
                    });
                }
            }
        }
    }

    public static void onLevelTick(Level level) {
        ServerLevel serverLevel;
        LunarPhaseData phaseData;
        ILunarEvent event;
        if (level.getGameTime() % 20L == 0L && level instanceof ServerLevel && (event = (phaseData = LunarPhaseData.get((Level)(serverLevel = (ServerLevel)level))).getActiveLunarEvent()) != null) {
            serverLevel.getAllEntities().forEach(entity -> {
                if (entity.isSpectator()) {
                    return;
                }
                event.removeEntityEffect((Entity)entity);
            });
        }
    }

    public static EventResult canSleep(Player player, BlockPos sleepingPos) {
        LunarPhaseData phaseData;
        ILunarEvent lunarEvent;
        Level level = player.level();
        if (!level.isClientSide && (lunarEvent = (phaseData = LunarPhaseData.get(level)).getActiveLunarEvent()) != null) {
            EventResult result = lunarEvent.canSleep(player, sleepingPos);
            if (result == EventResult.DENY) {
                MutableComponent denyComponent = Component.translatable((String)"lunar.event.sleep_canceled", (Object[])new Object[]{Component.translatable((String)lunarEvent.getTranslationKey())}).withStyle(ChatFormatting.RED);
                player.displayClientMessage((Component)denyComponent, true);
            }
            return result;
        }
        return EventResult.DEFAULT;
    }

    public static EventResult getSpawnResult(EntitySpawnReason mobSpawnType, LivingEntity livingEntity) {
        LunarPhaseData phaseData;
        ILunarEvent lunarEvent;
        Level level = livingEntity.level();
        if (!level.isClientSide && (lunarEvent = (phaseData = LunarPhaseData.get(level)).getActiveLunarEvent()) != null && lunarEvent.dictatesMobSpawn()) {
            return lunarEvent.getSpawnResult(livingEntity, mobSpawnType);
        }
        return EventResult.DEFAULT;
    }

    public static void uponLivingSpawn(EntitySpawnReason mobSpawnType, LivingEntity livingEntity) {
        LunarPhaseData phaseData;
        ILunarEvent lunarEvent;
        Level level = livingEntity.level();
        if (!level.isClientSide && (lunarEvent = (phaseData = LunarPhaseData.get(level)).getActiveLunarEvent()) != null && lunarEvent.applySpawnEffect()) {
            lunarEvent.applySpawnEffect(livingEntity, mobSpawnType);
        }
    }
}

