/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.registry.events;

import com.mrbysco.lunar.Constants;
import com.mrbysco.lunar.api.LunarEvent;
import com.mrbysco.lunar.handler.result.EventResult;
import com.mrbysco.lunar.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class BloodMoonEvent
extends LunarEvent {
    private static final ResourceLocation MOON_TEXTURE = Constants.modLoc("textures/environment/blood.png");
    private static final ResourceLocation DAMAGE_MODIFIER_UUID = Constants.modLoc("blood_moon_damage_modifier");
    private static final ResourceLocation HEALTH_MODIFIER_UUID = Constants.modLoc("blood_moon_health_modifier");

    public BloodMoonEvent() {
        super(Constants.modLoc("blood_moon"), 0x882E2E);
    }

    @Override
    public int spawnWeight() {
        return Services.PLATFORM.getBloodMoonWeight();
    }

    @Override
    public String getTranslationKey() {
        return "lunar.event.blood_moon";
    }

    @Override
    public boolean applySpawnEffect() {
        return true;
    }

    @Override
    public void applySpawnEffect(LivingEntity livingEntity, EntitySpawnReason spawnType) {
        if (spawnType == EntitySpawnReason.NATURAL) {
            AttributeInstance healthAttribute;
            float difficultyMultiplier = livingEntity.level().getCurrentDifficultyAt(livingEntity.blockPosition()).getSpecialMultiplier();
            RandomSource random = livingEntity.getRandom();
            AttributeInstance attackAttribute = livingEntity.getAttribute(Attributes.ATTACK_DAMAGE);
            if (attackAttribute != null) {
                int damageBoost = 0;
                if (difficultyMultiplier > 0.0f) {
                    int i = (int)Math.floor(2.0f * difficultyMultiplier);
                    int n = damageBoost = i > 0 ? random.nextInt(i) : 0;
                }
                if (damageBoost > 0) {
                    attackAttribute.addTransientModifier(new AttributeModifier(DAMAGE_MODIFIER_UUID, (double)damageBoost, AttributeModifier.Operation.ADD_VALUE));
                }
            }
            if ((healthAttribute = livingEntity.getAttribute(Attributes.MAX_HEALTH)) != null) {
                int healthBoost = 0;
                if (difficultyMultiplier > 0.0f) {
                    int i = (int)Math.floor(2.0f * difficultyMultiplier);
                    int n = healthBoost = i > 0 ? random.nextInt(i) : 0;
                }
                if (healthBoost > 0) {
                    healthAttribute.addTransientModifier(new AttributeModifier(HEALTH_MODIFIER_UUID, (double)healthBoost, AttributeModifier.Operation.ADD_VALUE));
                }
            }
        }
    }

    @Override
    public void removeEntityEffect(Entity entity) {
        LivingEntity livingEntity;
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).isAlive()) {
            AttributeInstance healthAttribute;
            AttributeInstance attackAttribute = livingEntity.getAttribute(Attributes.ATTACK_DAMAGE);
            if (attackAttribute != null) {
                attackAttribute.removeModifier(DAMAGE_MODIFIER_UUID);
            }
            if ((healthAttribute = livingEntity.getAttribute(Attributes.MAX_HEALTH)) != null) {
                healthAttribute.removeModifier(HEALTH_MODIFIER_UUID);
            }
        }
    }

    @Override
    public ResourceLocation moonTexture() {
        return MOON_TEXTURE;
    }

    @Override
    public EventResult canSleep(Player player, BlockPos sleepingLocation) {
        if (!Services.PLATFORM.canSleepIn(this.getID())) {
            return EventResult.DENY;
        }
        return EventResult.DEFAULT;
    }
}

