/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar;

import com.mojang.brigadier.CommandDispatcher;
import com.mrbysco.lunar.CommonClass;
import com.mrbysco.lunar.Constants;
import com.mrbysco.lunar.LunarPhaseData;
import com.mrbysco.lunar.commands.LunarCommands;
import com.mrbysco.lunar.config.LunarConfig;
import com.mrbysco.lunar.events.EntityEvents;
import com.mrbysco.lunar.events.PlayerEvents;
import com.mrbysco.lunar.handler.LunarHandler;
import com.mrbysco.lunar.handler.result.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.annotation.Nullable;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1269;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1329;
import net.minecraft.class_1657;
import net.minecraft.class_1917;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_7923;

public class Lunar
implements ModInitializer {
    public static final class_1320 ENTITY_GRAVITY = new class_1329("lunar.entity_gravity", 0.08, -8.0, 8.0).method_26829(true);
    public static LunarConfig config;

    public void onInitialize() {
        ConfigHolder holder = AutoConfig.register(LunarConfig.class, Toml4jConfigSerializer::new);
        config = (LunarConfig)holder.getConfig();
        ServerLifecycleEvents.SERVER_STARTING.register(server -> CommonClass.initRegistry());
        CommandRegistrationCallback.EVENT.register((dispatcher, context, selection) -> LunarCommands.initializeCommands((CommandDispatcher<class_2168>)dispatcher));
        EntitySleepEvents.ALLOW_SLEEP_TIME.register(this::onSleepCheck);
        EntityEvents.LIVING_SPECIAL_SPAWN.register(this::onLivingSpawn);
        if (FabricLoader.getInstance().isModLoaded("architectury")) {
            EntityEvent.LIVING_CHECK_SPAWN.register((entity, level, x, y, z, type, spawner) -> {
                class_1269 result = this.onCheckSpawn(entity, level, x, y, z, type, spawner);
                if (result == class_1269.field_5814) {
                    return dev.architectury.event.EventResult.interruptDefault();
                }
                if (result == class_1269.field_5812) {
                    return dev.architectury.event.EventResult.interruptTrue();
                }
                return dev.architectury.event.EventResult.pass();
            });
        } else {
            EntityEvents.LIVING_CHECK_SPAWN.register(this::onCheckSpawn);
        }
        ServerTickEvents.END_WORLD_TICK.register(this::onWorldTick);
        PlayerEvents.PLAYER_LOGIN.register(this::onLogin);
        class_2378.method_10230((class_2378)class_7923.field_41190, (class_2960)Constants.modLoc("entity_gravity"), (Object)ENTITY_GRAVITY);
    }

    private class_1269 onSleepCheck(class_1657 player, class_2338 sleepingPos, boolean vanillaResult) {
        EventResult result;
        if (player.method_37908().method_27983().equals(class_1937.field_25179) && (result = LunarHandler.canSleep(player, sleepingPos)) != EventResult.DEFAULT) {
            return result == EventResult.DENY ? class_1269.field_5814 : class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private void onLivingSpawn(class_1308 entity, class_1936 level, float x, float y, float z, @Nullable class_1917 spawner, class_3730 spawnReason) {
        if (entity.method_37908().method_27983().equals(class_1937.field_25179)) {
            LunarHandler.uponLivingSpawn(spawnReason, (class_1309)entity);
        }
    }

    private class_1269 onCheckSpawn(class_1309 entity, class_1936 level, double x, double y, double z, class_3730 type, @Nullable class_1917 spawner) {
        EventResult spawnResult;
        if (entity.method_37908().method_27983().equals(class_1937.field_25179) && (spawnResult = LunarHandler.getSpawnResult(type, entity)) != EventResult.DEFAULT) {
            if (spawnResult == EventResult.ALLOW) {
                return class_1269.field_5812;
            }
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    private void onWorldTick(class_3218 level) {
        if (level.method_27983().equals(class_1937.field_25179)) {
            LunarHandler.onWorldTick((class_1937)level);
        }
    }

    public void onLogin(class_3222 player) {
        class_1937 level = player.method_37908();
        if (!level.field_9236) {
            LunarPhaseData phaseData = LunarPhaseData.get(player.method_37908());
            phaseData.syncEvent(player);
        }
    }
}

