/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar;

import com.mrbysco.lunar.api.ILunarEvent;
import com.mrbysco.lunar.platform.Services;
import com.mrbysco.lunar.registry.LunarRegistry;
import java.util.Random;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_26;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class LunarPhaseData
extends class_18 {
    private static final Random random = new Random();
    private static final String DATA_NAME = "lunar_world_data";
    public ILunarEvent forcedEvent;
    public ILunarEvent activeEvent;

    public LunarPhaseData() {
        this.setActiveEvent(null);
        this.setForcedEvent(null);
    }

    public LunarPhaseData(ILunarEvent event, ILunarEvent forcedEvent) {
        this.setActiveEvent(event);
        this.setForcedEvent(forcedEvent);
    }

    public class_2487 method_75(class_2487 compound) {
        if (this.activeEvent != null) {
            compound.method_10582("event", this.activeEvent.getID().toString());
        }
        if (this.forcedEvent != null) {
            compound.method_10582("forcedEvent", this.forcedEvent.getID().toString());
        }
        return compound;
    }

    public static LunarPhaseData load(class_2487 compound) {
        class_2960 eventID = compound.method_10558("event").isEmpty() ? null : class_2960.method_12829((String)compound.method_10558("event"));
        ILunarEvent event = eventID != null ? LunarRegistry.instance().getEventByID(eventID) : null;
        class_2960 forcedEventID = compound.method_10558("forcedEvent").isEmpty() ? null : class_2960.method_12829((String)compound.method_10558("forcedEvent"));
        ILunarEvent forcedEvent = forcedEventID != null ? LunarRegistry.instance().getEventByID(forcedEventID) : null;
        return new LunarPhaseData(event, forcedEvent);
    }

    public static LunarPhaseData get(class_1937 level) {
        if (!(level instanceof class_3218)) {
            throw new RuntimeException("Attempted to get the data from a client world. This is wrong.");
        }
        class_3218 overworld = level.method_8503().method_3847(class_1937.field_25179);
        class_26 storage = overworld.method_17983();
        return (LunarPhaseData)storage.method_17924(LunarPhaseData::load, LunarPhaseData::new, DATA_NAME);
    }

    public void setRandomLunarEvent(class_1937 level) {
        if (this.forcedEvent != null) {
            class_5250 startComponent = class_2561.method_43469((String)"lunar.event.start", (Object[])new Object[]{class_2561.method_43471((String)this.forcedEvent.getTranslationKey())});
            level.method_18456().forEach(arg_0 -> LunarPhaseData.lambda$setRandomLunarEvent$0((class_2561)startComponent, arg_0));
            this.setActiveEvent(this.forcedEvent);
            this.setForcedEvent(null);
        } else {
            ILunarEvent event;
            float rng = random.nextFloat();
            if (rng <= Services.PLATFORM.getLunarChance() && (event = LunarRegistry.instance().getRandomLunarEvent(level)) != null) {
                class_5250 startComponent = class_2561.method_43469((String)"lunar.event.start", (Object[])new Object[]{class_2561.method_43471((String)event.getTranslationKey())});
                level.method_18456().forEach(arg_0 -> LunarPhaseData.lambda$setRandomLunarEvent$1((class_2561)startComponent, arg_0));
                this.setActiveEvent(event);
                return;
            }
            this.setDefaultMoon();
        }
    }

    public void setForcedEvent(ILunarEvent event) {
        this.forcedEvent = event;
        this.method_80();
    }

    public void eraseEvent() {
        this.setActiveEvent(null);
    }

    public void setDefaultMoon() {
        this.setActiveEvent(LunarRegistry.getDefaultMoon());
        this.setForcedEvent(null);
    }

    public void setActiveEvent(ILunarEvent storage) {
        this.activeEvent = storage;
        this.method_80();
    }

    public void syncEvent(class_1937 level) {
        Services.PLATFORM.syncEvent(level, this.activeEvent != null ? this.activeEvent : null);
    }

    public void syncEvent(class_3222 player) {
        Services.PLATFORM.syncEvent(player, this.activeEvent != null ? this.activeEvent : null);
    }

    public ILunarEvent getActiveLunarEvent() {
        return this.activeEvent != null ? this.activeEvent : null;
    }

    public boolean hasEventActive() {
        return this.activeEvent != null;
    }

    private static /* synthetic */ void lambda$setRandomLunarEvent$1(class_2561 startComponent, class_1657 player) {
        player.method_43496(startComponent);
    }

    private static /* synthetic */ void lambda$setRandomLunarEvent$0(class_2561 startComponent, class_1657 player) {
        player.method_43496(startComponent);
    }
}

