/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mrbysco.lunar.LunarPhaseData;
import com.mrbysco.lunar.api.ILunarEvent;
import com.mrbysco.lunar.platform.Services;
import com.mrbysco.lunar.registry.LunarRegistry;
import com.mrbysco.lunar.registry.events.BigMoonEvent;
import com.mrbysco.lunar.registry.events.TinyMoonEvent;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public class LunarCommands {
    public static void initializeCommands(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder root = class_2170.method_9247((String)"lunar");
        ((LiteralArgumentBuilder)root.requires(sourceStack -> sourceStack.method_9259(2))).then(class_2170.method_9247((String)"forceEvent").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"eventID", (ArgumentType)class_2232.method_9441()).suggests((cs, builder) -> class_2172.method_9265(LunarRegistry.instance().getIDList(), (SuggestionsBuilder)builder)).executes(ctx -> LunarCommands.forceEvent((CommandContext<class_2168>)ctx, false))).then(class_2170.method_9244((String)"forceCurrent", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> LunarCommands.forceEvent((CommandContext<class_2168>)ctx, BoolArgumentType.getBool((CommandContext)ctx, (String)"forceCurrent"))))));
        ((LiteralArgumentBuilder)root.requires(sourceStack -> sourceStack.method_9259(2))).then(class_2170.method_9247((String)"skip").executes(LunarCommands::skipEvent));
        ((LiteralArgumentBuilder)root.requires(sourceStack -> sourceStack.method_9259(2))).then(class_2170.method_9247((String)"randomize").executes(LunarCommands::randomizeEvent));
        ((LiteralArgumentBuilder)root.requires(sourceStack -> sourceStack.method_9259(2))).then(class_2170.method_9247((String)"clearGravity").executes(LunarCommands::clearGravity));
        dispatcher.register(root);
    }

    private static int forceEvent(CommandContext<class_2168> ctx, boolean forceCurrent) {
        class_2960 eventID = class_2232.method_9443(ctx, (String)"eventID");
        class_3218 level = ((class_2168)ctx.getSource()).method_9211().method_3847(class_1937.field_25179);
        LunarPhaseData phaseData = LunarPhaseData.get((class_1937)level);
        ILunarEvent event = LunarRegistry.instance().getEventByID(eventID);
        if (event == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("No lunar event found with ID: " + String.valueOf(eventID))));
            return 0;
        }
        if (forceCurrent) {
            phaseData.getActiveLunarEvent().stopEffects((class_1937)level);
            phaseData.setActiveEvent(event);
            phaseData.syncEvent((class_1937)level);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Successfully forced a " + class_2561.method_43471((String)event.getTranslationKey()).getString() + " moon")), true);
        } else {
            phaseData.setForcedEvent(event);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Successfully forced a " + class_2561.method_43471((String)event.getTranslationKey()).getString() + " moon next night")), true);
        }
        return 0;
    }

    private static int skipEvent(CommandContext<class_2168> ctx) {
        class_3218 level = ((class_2168)ctx.getSource()).method_9211().method_3847(class_1937.field_25179);
        LunarPhaseData phaseData = LunarPhaseData.get((class_1937)level);
        phaseData.getActiveLunarEvent().stopEffects((class_1937)level);
        phaseData.setDefaultMoon();
        phaseData.syncEvent((class_1937)level);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully skipped the lunar event for tonight"), true);
        return 0;
    }

    private static int randomizeEvent(CommandContext<class_2168> ctx) {
        class_3218 level = ((class_2168)ctx.getSource()).method_9211().method_3847(class_1937.field_25179);
        LunarPhaseData phaseData = LunarPhaseData.get((class_1937)level);
        phaseData.getActiveLunarEvent().stopEffects((class_1937)level);
        phaseData.setRandomLunarEvent((class_1937)level);
        phaseData.syncEvent((class_1937)level);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully randomized the lunar event for tonight"), true);
        return 0;
    }

    private static int clearGravity(CommandContext<class_2168> ctx) {
        class_3218 level = ((class_2168)ctx.getSource()).method_9211().method_3847(class_1937.field_25179);
        level.method_27909().forEach(entity -> {
            class_1309 livingEntity;
            class_1324 attributeInstance;
            class_1320 gravityAttribute = Services.PLATFORM.getGravityAttribute();
            if (entity instanceof class_1309 && (attributeInstance = (livingEntity = (class_1309)entity).method_5996(gravityAttribute)) != null) {
                attributeInstance.method_6202(BigMoonEvent.GRAVITY_MODIFIER);
                attributeInstance.method_6202(TinyMoonEvent.GRAVITY_MODIFIER);
            }
        });
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully cleared gravity modifiers from all entities"), true);
        return 0;
    }
}

