/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.config;

import com.mrbysco.lunar.CommonClass;
import java.util.List;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

@Config(name="lunar")
public class LunarConfig
implements ConfigData {
    @ConfigEntry.Gui.CollapsibleObject
    public General general = new General();
    @ConfigEntry.Gui.CollapsibleObject
    public Events events = new Events();
    @ConfigEntry.Gui.CollapsibleObject
    public Crimson crimson = new Crimson();
    @ConfigEntry.Gui.CollapsibleObject
    public BadOmen badomen = new BadOmen();
    @ConfigEntry.Gui.CollapsibleObject
    public Sleeping sleeping = new Sleeping();

    public static class General {
        @Comment(value="Chance of a Lunar Event happening when night falls [Default: 0.4]")
        @ConfigEntry.BoundedDiscrete(min=0L, max=1L)
        public float lunarEventChance = 0.4f;
    }

    public static class Events {
        @Comment(value="Weight of the Blood Moon Event [Default: 60]")
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public int bloodMoonWeight = 60;
        @Comment(value="Weight of the Blood Moon Event [Default: 20]")
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public int crimsonMoonWeight = 20;
        @Comment(value="Weight of the Blood Moon Event [Default: 40]")
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public int minerMoonWeight = 40;
        @Comment(value="Weight of the Blood Moon Event [Default: 10]")
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public int whiteMoonWeight = 10;
        @Comment(value="Weight of the Tiny Moon Event [Default: 10]")
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public int tinyMoonWeight = 10;
        @Comment(value="Weight of the Big Moon Event [Default: 10]")
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public int bigMoonWeight = 10;
        @Comment(value="Weight of the Bad Omen Moon Event [Default: 5]")
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public int badOmenMoonWeight = 5;
        @Comment(value="Weight of the Hero Moon Event [Default: 5]")
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public int heroMoonWeight = 5;
        @Comment(value="Weight of the Eclipse Moon Event [Default: 2]")
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public int eclipseMoonWeight = 2;
    }

    public static class Crimson {
        @Comment(value="List of entities to replace during the Crimson Moon Event [Example: \"minecraft:zombie,minecraft:zombified_piglin\"]")
        public List<String> crimsonReplacements = CommonClass.DEFAULT_CRIMSON_REPLACEMENT;
    }

    public static class BadOmen {
        @Comment(value="The max level of Bad Omen effect applied during the Bad Omen Moon Event (It will apply a level between 1 and this max) [Default: 3]")
        public int maxBadOmen = 3;
    }

    public static class Sleeping {
        @Comment(value="Allow sleeping during the Blood Moon Event [Default: true]")
        public boolean bloodMoonSleeping = true;
        @Comment(value="Allow sleeping during the Crimson Moon Event [Default: true]")
        public boolean crimsonMoonSleeping = true;
        @Comment(value="Allow sleeping during the Miner Moon Event [Default: true]")
        public boolean minerMoonSleeping = true;
        @Comment(value="Allow sleeping during the White Moon Event [Default: true]")
        public boolean whiteMoonSleeping = true;
        @Comment(value="Allow sleeping during the Tiny Moon Event [Default: true]")
        public boolean tinyMoonSleeping = true;
        @Comment(value="Allow sleeping during the Big Moon Event [Default: true]")
        public boolean bigMoonSleeping = true;
        @Comment(value="Allow sleeping during the Bad Omen Moon Event [Default: true]")
        public boolean badOmenMoonSleeping = true;
        @Comment(value="Allow sleeping during the Hero Moon Event [Default: true]")
        public boolean heroMoonSleeping = true;
        @Comment(value="Allow sleeping during the Eclipse Moon Event [Default: true]")
        public boolean eclipseMoonSleeping = true;
    }
}

