/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.handler;

import com.mrbysco.lunar.LunarPhaseData;
import com.mrbysco.lunar.api.ILunarEvent;
import com.mrbysco.lunar.handler.result.EventResult;
import com.mrbysco.lunar.platform.Services;
import com.mrbysco.lunar.registry.events.BigMoonEvent;
import com.mrbysco.lunar.registry.events.TinyMoonEvent;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5250;

public class LunarHandler {
    public static void onWorldTick(class_1937 level) {
        if (level.method_8510() % 20L == 0L && !level.field_9236) {
            class_3218 serverLevel = (class_3218)level;
            LunarPhaseData phaseData = LunarPhaseData.get((class_1937)serverLevel);
            ILunarEvent event = phaseData.getActiveLunarEvent();
            int currentTime = (int)(serverLevel.method_8532() % 24000L);
            if (currentTime > 13000 && currentTime < 23000) {
                if (!phaseData.hasEventActive()) {
                    phaseData.setRandomLunarEvent((class_1937)serverLevel);
                    phaseData.syncEvent((class_1937)serverLevel);
                } else if (event != null) {
                    if (event.applyEntityEffect()) {
                        serverLevel.method_27909().forEach(entity -> {
                            if (entity.method_7325()) {
                                return;
                            }
                            event.applyEntityEffect((class_1297)entity);
                        });
                    }
                    if (event.applyPlayerEffect()) {
                        serverLevel.method_18456().forEach(event::applyPlayerEffect);
                    }
                }
            } else if (phaseData.hasEventActive()) {
                if (event != null) {
                    if (event.applyEntityEffect()) {
                        serverLevel.method_27909().forEach(entity -> {
                            if (entity.method_7325()) {
                                return;
                            }
                            event.removeEntityEffect((class_1297)entity);
                        });
                    }
                    event.stopEffects((class_1937)serverLevel);
                }
                phaseData.eraseEvent();
                phaseData.syncEvent((class_1937)serverLevel);
            } else {
                serverLevel.method_27909().forEach(entity -> {
                    class_1309 livingEntity;
                    class_1324 attributeInstance;
                    class_1320 gravityAttribute = Services.PLATFORM.getGravityAttribute();
                    if (entity instanceof class_1309 && (attributeInstance = (livingEntity = (class_1309)entity).method_5996(gravityAttribute)) != null) {
                        attributeInstance.method_6202(BigMoonEvent.GRAVITY_MODIFIER);
                        attributeInstance.method_6202(TinyMoonEvent.GRAVITY_MODIFIER);
                    }
                });
            }
        }
    }

    public static EventResult canSleep(class_1657 player, class_2338 sleepingPos) {
        LunarPhaseData phaseData;
        ILunarEvent lunarEvent;
        class_1937 level = player.method_37908();
        if (!level.field_9236 && (lunarEvent = (phaseData = LunarPhaseData.get(level)).getActiveLunarEvent()) != null) {
            EventResult result = lunarEvent.canSleep(player, sleepingPos);
            if (result == EventResult.DENY) {
                class_5250 denyComponent = class_2561.method_43469((String)"lunar.event.sleep_canceled", (Object[])new Object[]{class_2561.method_43471((String)lunarEvent.getTranslationKey())}).method_27692(class_124.field_1061);
                player.method_7353((class_2561)denyComponent, true);
            }
            return result;
        }
        return EventResult.DEFAULT;
    }

    public static EventResult getSpawnResult(class_3730 mobSpawnType, class_1309 livingEntity) {
        LunarPhaseData phaseData;
        ILunarEvent lunarEvent;
        class_1937 level = livingEntity.method_37908();
        if (!level.field_9236 && (lunarEvent = (phaseData = LunarPhaseData.get(level)).getActiveLunarEvent()) != null && lunarEvent.dictatesMobSpawn()) {
            return lunarEvent.getSpawnResult(livingEntity, mobSpawnType);
        }
        return EventResult.DEFAULT;
    }

    public static void uponLivingSpawn(class_3730 mobSpawnType, class_1309 livingEntity) {
        LunarPhaseData phaseData;
        ILunarEvent lunarEvent;
        class_1937 level = livingEntity.method_37908();
        if (!level.field_9236 && (lunarEvent = (phaseData = LunarPhaseData.get(level)).getActiveLunarEvent()) != null && lunarEvent.applySpawnEffect()) {
            lunarEvent.applySpawnEffect(livingEntity, mobSpawnType);
        }
    }
}

