/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.platform;

import com.google.common.collect.Maps;
import com.mrbysco.lunar.Constants;
import com.mrbysco.lunar.Lunar;
import com.mrbysco.lunar.api.ILunarEvent;
import com.mrbysco.lunar.config.LunarConfig;
import com.mrbysco.lunar.platform.services.IPlatformHelper;
import java.util.HashMap;
import java.util.Map;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class FabricPlatformHelper
implements IPlatformHelper {
    @Override
    public void syncEvent(class_1937 level, ILunarEvent event) {
        if (!level.field_9236) {
            class_2540 buf = this.getSyncByteBuf(event);
            for (class_3222 player : ((class_3218)level).method_18456()) {
                ServerPlayNetworking.send((class_3222)player, (class_2960)Constants.SYNC_EVENT_ID, (class_2540)buf);
            }
        }
    }

    @Override
    public void syncEvent(class_3222 player, ILunarEvent event) {
        class_2540 buf = this.getSyncByteBuf(event);
        ServerPlayNetworking.send((class_3222)player, (class_2960)Constants.SYNC_EVENT_ID, (class_2540)buf);
    }

    @Override
    public void syncDeltaMovement(class_3222 player, class_243 deltaMovement) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeDouble(deltaMovement.field_1352);
        buf.writeDouble(deltaMovement.field_1351);
        buf.writeDouble(deltaMovement.field_1350);
        ServerPlayNetworking.send((class_3222)player, (class_2960)Constants.SYNC_MOVEMENT_EVENT_ID, (class_2540)buf);
    }

    private class_2540 getSyncByteBuf(ILunarEvent event) {
        class_2540 buf = PacketByteBufs.create();
        int moonColor = event != null ? event.moonColor() : -1;
        String eventID = event != null ? event.getID().toString() : "";
        float moonScale = event != null ? event.moonScale() : 1.0f;
        String customTexture = event != null && event.moonTexture() != null ? event.moonTexture().toString() : "";
        buf.writeInt(moonColor);
        buf.method_10814(eventID);
        buf.writeFloat(moonScale);
        buf.method_10814(customTexture);
        return buf;
    }

    @Override
    public float getLunarChance() {
        if (Lunar.config == null) {
            Lunar.config = (LunarConfig)AutoConfig.getConfigHolder(LunarConfig.class).getConfig();
        }
        return Lunar.config.general.lunarEventChance;
    }

    @Override
    public int getBloodMoonWeight() {
        if (Lunar.config == null) {
            Lunar.config = (LunarConfig)AutoConfig.getConfigHolder(LunarConfig.class).getConfig();
        }
        return Lunar.config.events.bloodMoonWeight;
    }

    @Override
    public int getCrimsonMoonWeight() {
        if (Lunar.config == null) {
            Lunar.config = (LunarConfig)AutoConfig.getConfigHolder(LunarConfig.class).getConfig();
        }
        return Lunar.config.events.crimsonMoonWeight;
    }

    @Override
    public int getMinerMoonWeight() {
        if (Lunar.config == null) {
            Lunar.config = (LunarConfig)AutoConfig.getConfigHolder(LunarConfig.class).getConfig();
        }
        return Lunar.config.events.minerMoonWeight;
    }

    @Override
    public int getWhiteMoonWeight() {
        if (Lunar.config == null) {
            Lunar.config = (LunarConfig)AutoConfig.getConfigHolder(LunarConfig.class).getConfig();
        }
        return Lunar.config.events.whiteMoonWeight;
    }

    @Override
    public int getBigMoonWeight() {
        if (Lunar.config == null) {
            Lunar.config = (LunarConfig)AutoConfig.getConfigHolder(LunarConfig.class).getConfig();
        }
        return Lunar.config.events.bigMoonWeight;
    }

    @Override
    public int getTinyMoonWeight() {
        if (Lunar.config == null) {
            Lunar.config = (LunarConfig)AutoConfig.getConfigHolder(LunarConfig.class).getConfig();
        }
        return Lunar.config.events.tinyMoonWeight;
    }

    @Override
    public int getBadOmenMoonWeight() {
        if (Lunar.config == null) {
            Lunar.config = (LunarConfig)AutoConfig.getConfigHolder(LunarConfig.class).getConfig();
        }
        return Lunar.config.events.badOmenMoonWeight;
    }

    @Override
    public int getHeroMoonWeight() {
        if (Lunar.config == null) {
            Lunar.config = (LunarConfig)AutoConfig.getConfigHolder(LunarConfig.class).getConfig();
        }
        return Lunar.config.events.heroMoonWeight;
    }

    @Override
    public int getEclipseMoonWeight() {
        if (Lunar.config == null) {
            Lunar.config = (LunarConfig)AutoConfig.getConfigHolder(LunarConfig.class).getConfig();
        }
        return Lunar.config.events.eclipseMoonWeight;
    }

    @Override
    public Map<class_2960, class_2960> getCrimsonReplacementMap() {
        if (Lunar.config == null) {
            Lunar.config = (LunarConfig)AutoConfig.getConfigHolder(LunarConfig.class).getConfig();
        }
        HashMap map = Maps.newHashMap();
        Lunar.config.crimson.crimsonReplacements.forEach(entry -> {
            if (entry.contains(",")) {
                String[] split = entry.split(",");
                map.put(class_2960.method_12829((String)split[0]), class_2960.method_12829((String)split[1]));
            }
        });
        return map;
    }

    @Override
    public class_2960 getEntityTypeLocation(class_1299<?> entityType) {
        return class_7923.field_41177.method_10221(entityType);
    }

    @Override
    public class_1299<?> getEntityType(class_2960 location) {
        return (class_1299)class_7923.field_41177.method_10223(location);
    }

    @Override
    public class_1320 getGravityAttribute() {
        return Lunar.ENTITY_GRAVITY;
    }

    @Override
    public boolean canSleepIn(class_2960 moonID) {
        if (Lunar.config == null) {
            Lunar.config = (LunarConfig)AutoConfig.getConfigHolder(LunarConfig.class).getConfig();
        }
        boolean result = true;
        switch (moonID.toString()) {
            case "lunar:blood_moon": {
                result = Lunar.config.sleeping.bloodMoonSleeping;
                break;
            }
            case "lunar:crimson_moon": {
                result = Lunar.config.sleeping.crimsonMoonSleeping;
                break;
            }
            case "lunar:miner_moon": {
                result = Lunar.config.sleeping.minerMoonSleeping;
                break;
            }
            case "lunar:white_moon": {
                result = Lunar.config.sleeping.whiteMoonSleeping;
                break;
            }
            case "lunar:big_moon": {
                result = Lunar.config.sleeping.bigMoonSleeping;
                break;
            }
            case "lunar:tiny_moon": {
                result = Lunar.config.sleeping.tinyMoonSleeping;
                break;
            }
            case "lunar:bad_omen_moon": {
                result = Lunar.config.sleeping.badOmenMoonSleeping;
                break;
            }
            case "lunar:hero_moon": {
                result = Lunar.config.sleeping.heroMoonSleeping;
                break;
            }
            case "lunar:eclipse_moon": {
                result = Lunar.config.sleeping.eclipseMoonSleeping;
            }
        }
        return result;
    }

    @Override
    public int maxBadOmen() {
        if (Lunar.config == null) {
            Lunar.config = (LunarConfig)AutoConfig.getConfigHolder(LunarConfig.class).getConfig();
        }
        return Lunar.config.badomen.maxBadOmen;
    }
}

