/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.registry;

import com.google.common.collect.Maps;
import com.mrbysco.lunar.Constants;
import com.mrbysco.lunar.api.ILunarEvent;
import com.mrbysco.lunar.registry.events.BadOmenMoonEvent;
import com.mrbysco.lunar.registry.events.BigMoonEvent;
import com.mrbysco.lunar.registry.events.BloodMoonEvent;
import com.mrbysco.lunar.registry.events.CrimsonMoonEvent;
import com.mrbysco.lunar.registry.events.EclipseMoonEvent;
import com.mrbysco.lunar.registry.events.HeroMoonEvent;
import com.mrbysco.lunar.registry.events.MinerMoonEvent;
import com.mrbysco.lunar.registry.events.RegularMoonEvent;
import com.mrbysco.lunar.registry.events.TinyMoonEvent;
import com.mrbysco.lunar.registry.events.WhiteMoonEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2960;

public class LunarRegistry {
    private static LunarRegistry INSTANCE;
    private final Map<class_2960, ILunarEvent> eventMap = Maps.newHashMap();
    private final List<ILunarEvent> eventList = new ArrayList<ILunarEvent>();

    public static LunarRegistry instance() {
        if (INSTANCE == null) {
            INSTANCE = new LunarRegistry();
        }
        return INSTANCE;
    }

    public void initializeLunarEvents() {
        this.eventMap.clear();
        this.eventList.clear();
        this.registerEvent(new BloodMoonEvent());
        this.registerEvent(new CrimsonMoonEvent());
        this.registerEvent(new MinerMoonEvent());
        this.registerEvent(new WhiteMoonEvent());
        this.registerEvent(new BigMoonEvent());
        this.registerEvent(new TinyMoonEvent());
        this.registerEvent(new BadOmenMoonEvent());
        this.registerEvent(new HeroMoonEvent());
        this.registerEvent(new EclipseMoonEvent());
    }

    public static ILunarEvent getDefaultMoon() {
        return new RegularMoonEvent();
    }

    public void sortByWeight() {
        this.eventList.sort(Comparator.comparingInt(ILunarEvent::spawnWeight));
    }

    public void registerEvent(ILunarEvent event) {
        class_2960 id = event.getID();
        if (!this.eventMap.containsKey(id)) {
            Constants.LOGGER.debug("Adding Lunar Event: {}", (Object)id.toString());
            this.eventMap.put(id, event);
            this.eventList.add(event);
        } else {
            Constants.LOGGER.error("Failed to add lunar event. There was an attempt to add duplicate lunar event {} of class {}", (Object)id, (Object)event.getClass().getName());
        }
        this.sortByWeight();
    }

    public ILunarEvent getEventByID(class_2960 ID) {
        if (this.eventMap.containsKey(ID)) {
            return this.eventMap.get(ID);
        }
        return null;
    }

    public ILunarEvent getRandomLunarEvent(class_1937 level) {
        ArrayList<ILunarEvent> eventCopy = new ArrayList<ILunarEvent>(this.eventList);
        eventCopy.removeIf(event -> !event.canAppear(level));
        if (eventCopy.isEmpty()) {
            return null;
        }
        double totalWeight = 0.0;
        for (ILunarEvent i : eventCopy) {
            totalWeight += (double)i.spawnWeight();
        }
        int randomIndex = -1;
        double random = Math.random() * totalWeight;
        for (int i = 0; i < eventCopy.size(); ++i) {
            if (!((random -= (double)((ILunarEvent)eventCopy.get(i)).spawnWeight()) <= 0.0)) continue;
            randomIndex = i;
            break;
        }
        return (ILunarEvent)eventCopy.get(randomIndex);
    }

    public List<String> getIDList() {
        ArrayList<String> list = new ArrayList<String>();
        for (ILunarEvent i : this.eventList) {
            list.add(i.getID().toString());
        }
        return list;
    }
}

